package li.rudin.rt.api.observable;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * Observable Value
 * @author user
 *
 * @param <T>
 */
public class Observable<T>
{
	
	/**
	 * Creates an observer with null value
	 */
	public Observable() {}
	
	/**
	 * Creates an observer with given default value
	 * @param value
	 */
	public Observable(T value)
	{
		set(value);
	}
	
	/**
	 * All local listeners
	 */
	private List<Listener<T>> listeners = new CopyOnWriteArrayList<>();
	
	/**
	 * The current value
	 */
	private T value;
	
	/**
	 * Sets the new value and invokes all listeners
	 * @param value
	 */
	public void set(T value)
	{
		if (value != null && this.value != null && value.equals(this.value))
			//No changes
			return;
		
		T oldValue = this.value;
		this.value = value;
		
		for (Listener<T> l: listeners)
			l.onChange(oldValue, value);
	}

	/**
	 * Returns the current value
	 * @return
	 */
	public T get()
	{
		return value;
	}
	
	/**
	 * Adds a local listener
	 * @param l
	 */
	public void addListener(Listener<T> l)
	{
		listeners.add(l);
	}
	
	/**
	 * Removes the local listener
	 * @param l
	 */
	public void removeListener(Listener<T> l)
	{
		listeners.remove(l);
	}
	
}
