/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.rt.api.computed;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import li.rudin.rt.api.computed.ComputedValue;
import li.rudin.rt.api.computed.ObservableAccessor;
import li.rudin.rt.api.observable.Listener;
import li.rudin.rt.api.observable.Observable;

public class Computed<T>
implements ObservableAccessor,
Listener<Object> {
    private final ComputedValue<T> cv;
    private T value;
    private boolean registerObservables = true;
    private List<Listener<T>> listeners = new CopyOnWriteArrayList<Listener<T>>();

    public Computed(ComputedValue<T> cv) {
        this.cv = cv;
        this.recompute();
    }

    public T get() {
        return this.value;
    }

    private void recompute() {
        T oldValue = this.value;
        this.value = this.cv.compute(this);
        this.registerObservables = false;
        for (Listener<T> l : this.listeners) {
            l.onChange(oldValue, this.value);
        }
    }

    public <V> V get(Observable<V> o) {
        if (this.registerObservables) {
            o.addListener(this);
        }
        return o.get();
    }

    @Override
    public void onChange(Object oldValue, Object newValue) {
        this.recompute();
    }

    public void addListener(Listener<T> l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener<T> l) {
        this.listeners.remove(l);
    }
}

