/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.rt.api.observable;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import li.rudin.rt.api.observable.Listener;

public class Observable<T> {
    private List<Listener<T>> listeners = new CopyOnWriteArrayList<Listener<T>>();
    private T value;

    public Observable() {
    }

    public Observable(T value) {
        this.set(value);
    }

    public void set(T value) {
        if (value != null && this.value != null && value.equals(this.value)) {
            return;
        }
        T oldValue = this.value;
        this.value = value;
        for (Listener<T> l : this.listeners) {
            l.onChange(oldValue, value);
        }
    }

    public T get() {
        return this.value;
    }

    public void addListener(Listener<T> l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener<T> l) {
        this.listeners.remove(l);
    }
}

