package li.rudin.rt.api.observable;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

import li.rudin.rt.api.observable.base.BasicObservable;

/**
 * Observable Value
 * @author user
 *
 * @param <T>
 */
public class Observable<T> implements BasicObservable<T>
{
	
	/**
	 * Creates an observer with null value
	 */
	public Observable() {}
	
	/**
	 * Creates an observer with given default value
	 * @param value
	 */
	public Observable(T value)
	{
		set(value);
	}
	
	/**
	 * All local listeners
	 */
	private Set<Listener<T>> listeners = new CopyOnWriteArraySet<>();
	
	/**
	 * The current value
	 */
	private T value;
	
	@Override
	public void set(T value)
	{
		if (value != null && this.value != null && value.equals(this.value))
			//No changes
			return;
		
		T oldValue = this.value;
		this.value = value;
		
		for (Listener<T> l: listeners)
			l.onChange(oldValue, value);
	}

	@Override
	public T get()
	{
		return value;
	}
	
	@Override
	public void addListener(Listener<T> l)
	{
		listeners.add(l);
	}

	@Override
	public void removeListener(Listener<T> l)
	{
		listeners.remove(l);
	}

	@Override
	public String toString()
	{
		return "Observable [listeners=" + listeners + ", value=" + value + "]";
	}
	
}
