/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.rt.api.observable;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import li.rudin.rt.api.observable.Listener;
import li.rudin.rt.api.observable.base.BasicObservable;

public class Observable<T>
implements BasicObservable<T> {
    private Set<Listener<T>> listeners = new CopyOnWriteArraySet<Listener<T>>();
    private T value;

    public Observable() {
    }

    public Observable(T value) {
        this.set(value);
    }

    @Override
    public void set(T value) {
        if (value != null && this.value != null && value.equals(this.value)) {
            return;
        }
        T oldValue = this.value;
        this.value = value;
        for (Listener<T> l : this.listeners) {
            l.onChange(oldValue, value);
        }
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void addListener(Listener<T> l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(Listener<T> l) {
        this.listeners.remove(l);
    }

    public String toString() {
        return "Observable [listeners=" + this.listeners + ", value=" + this.value + "]";
    }
}

