/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.rt.api.weak;

import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArraySet;

public class CopyOnWriteWeakReferenceSet<E>
extends AbstractSet<E> {
    private CopyOnWriteArraySet<WeakReference<E>> items = new CopyOnWriteArraySet();

    public CopyOnWriteWeakReferenceSet() {
    }

    public CopyOnWriteWeakReferenceSet(Collection<E> c) {
        this.addAll(c);
    }

    @Override
    public boolean add(E element) {
        if (this.contains(element)) {
            return false;
        }
        return this.items.add(new WeakReference<E>(element));
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = false;
        Object element = null;
        for (WeakReference<E> ref : this.items) {
            element = ref.get();
            if (element == null || !element.equals(o)) continue;
            ref.clear();
            removed = true;
            break;
        }
        if (removed) {
            this.removeReleased();
        }
        return removed;
    }

    @Override
    public boolean contains(Object o) {
        ArrayList list = new ArrayList();
        for (WeakReference<E> ref : this.items) {
            if (ref.get() == null) continue;
            list.add(ref.get());
        }
        boolean contains = list.contains(o);
        list.clear();
        list = null;
        return contains;
    }

    @Override
    public int size() {
        this.removeReleased();
        return this.items.size();
    }

    private void removeReleased() {
        for (WeakReference<E> ref : this.items) {
            if (ref.get() != null) continue;
            this.items.remove(ref);
        }
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<WeakReference<E>> iter = this.items.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public E next() {
                return ((WeakReference)iter.next()).get();
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }
}

