package li.rudin.rt.api.resource;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceMapping
{

	private static final List<MappedResource> mapping = new ArrayList<>();
	private static final Logger logger = LoggerFactory.getLogger(ResourceMapping.class);
	
	/**
	 * Adds a mapped resource
	 * @param res
	 */
	public static void add(MappedResource res)
	{
		mapping.add(res);
		logger.debug("Added resource name({}) contentType({})", res.getName(), res.getContentType());
	}
	
	/**
	 * Returns all mappings
	 * @return
	 */
	public static List<MappedResource> getMapping()
	{
		return mapping;
	}
	
}
