/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.rt.api.observable;

import java.util.LinkedList;
import li.rudin.rt.api.observable.Observable;

public class AveragingObservable
extends Observable<Double> {
    private final int samples;
    private final LinkedList<Double> queue = new LinkedList();
    private Double min;
    private Double max;
    private Double avg;

    public AveragingObservable() {
        this(5);
    }

    public AveragingObservable(int samples) {
        this.samples = samples;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    @Override
    public void set(Double value) {
        this.queue.add(value);
        if (this.queue.size() > this.samples) {
            this.queue.removeFirst();
        }
        Double min = null;
        Double max = null;
        Double sum = 0.0;
        for (Double d : this.queue) {
            if (min == null || d < min) {
                min = d;
            }
            if (max == null || d > min) {
                max = d;
            }
            sum = sum + d;
        }
        this.avg = sum / (double)this.queue.size();
        this.max = max;
        this.min = min;
        super.set(this.avg);
    }
}

