/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.rt.api.observable.computed;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import li.rudin.rt.api.observable.Listener;
import li.rudin.rt.api.observable.base.ObservableGetter;
import li.rudin.rt.api.observable.computed.ComputedValue;
import li.rudin.rt.api.observable.computed.ObservableAccessor;

public class Computed<T>
implements ObservableAccessor,
Listener<Object>,
ObservableGetter<T> {
    private final ComputedValue<T> cv;
    private T value;
    private boolean registerObservables = true;
    private Set<Listener<T>> listeners = new CopyOnWriteArraySet<Listener<T>>();

    public Computed(ComputedValue<T> cv) {
        this.cv = cv;
        this.recompute();
    }

    @Override
    public T get() {
        return this.value;
    }

    private void recompute() {
        T oldValue = this.value;
        this.value = this.cv.compute(this);
        this.registerObservables = false;
        for (Listener<T> l : this.listeners) {
            l.onChange(oldValue, this.value);
        }
    }

    public <V> V get(ObservableGetter<V> o) {
        if (this.registerObservables) {
            o.addListener(this);
        }
        return (V)o.get();
    }

    @Override
    public void onChange(Object oldValue, Object newValue) {
        this.recompute();
    }

    @Override
    public void addListener(Listener<T> l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(Listener<T> l) {
        this.listeners.remove(l);
    }

    public String toString() {
        return "Computed [cv=" + this.cv + ", value=" + this.value + ", listeners=" + this.listeners + "]";
    }
}

