/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.rt.api.observable.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import li.rudin.rt.api.observable.list.ListListener;

public class ObservableList<T>
implements List<T> {
    private Set<ListListener<T>> listListeners = new CopyOnWriteArraySet<ListListener<T>>();
    private final List<T> list;

    public ObservableList() {
        this(new ArrayList());
    }

    public ObservableList(List<T> list) {
        this.list = list;
    }

    public List<T> getList() {
        return this.list;
    }

    public void addListListener(ListListener<T> l) {
        this.listListeners.add(l);
    }

    public void removeListListener(ListListener<T> l) {
        this.listListeners.remove(l);
    }

    @Override
    public boolean add(T e) {
        for (ListListener<T> ll : this.listListeners) {
            ll.onAdd(e);
        }
        return this.list.add(e);
    }

    @Override
    public void add(int index, T element) {
        for (ListListener<T> ll : this.listListeners) {
            ll.onAdd(element, index);
        }
        this.list.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (ListListener<T> ll : this.listListeners) {
            for (T obj : c) {
                ll.onAdd(obj);
            }
        }
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new IllegalArgumentException("Sorry, not implemented, yet");
    }

    @Override
    public void clear() {
        for (ListListener<T> ll : this.listListeners) {
            ll.onClear();
        }
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        this.remove(this.list.indexOf(o));
        return true;
    }

    @Override
    public T remove(int index) {
        for (ListListener<T> ll : this.listListeners) {
            ll.onRemove(index);
        }
        return this.list.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            this.remove(o);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        for (T t : this.list) {
            if (c.contains(t)) continue;
            this.remove(t);
        }
        return true;
    }

    @Override
    public T set(int index, T element) {
        for (ListListener<T> ll : this.listListeners) {
            ll.onReplace(element, index);
        }
        return this.list.set(index, element);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new IllegalArgumentException("Sorry, not implemented, yet");
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <O> O[] toArray(O[] a) {
        return this.list.toArray(a);
    }
}

