package li.rudin.rt.api;


public interface RTClient
{
	/**
	 * Sends an object  with a specific changeId to the client(s)
	 * @param o
	 */
	void send(String changeId, Object o);
	
	/**
	 * Sends an object with a annotated changeId to the client(s)
	 * @see li.rudin.rt.api.annotations.ChangeId
	 * @param o
	 */
	void send(Object o);
		
	/**
	 * Returns true, if active
	 * @return
	 */
	boolean isActive();
	
	/**
	 * Returns the count of all sent object
	 * @return
	 */
	long getCount();
	
	/**
	 * Returns the id of the client
	 * @return
	 */
	String getId();
}
