package li.rudin.rt.api;

import li.rudin.rt.api.config.RTConfig;
import li.rudin.rt.api.filter.RTFilter;
import li.rudin.rt.api.listener.RTListener;
import li.rudin.rt.api.observable.Observable;
import li.rudin.rt.api.observable.list.ObservableList;

public interface RTServer extends RTClient
{

	/**
	 * Sets a filter instance
	 * @param filter
	 */
	void setFilter(RTFilter filter);
	
	/**
	 * Returns the set filter
	 * @return
	 */
	RTFilter getFilter();
	
	/**
	 * Adds a listener
	 * @param listener
	 */
	void addListener(RTListener listener);
	
	/**
	 * Removes a listener
	 * @param listener
	 */
	void removeListener(RTListener listener);
	
	/**
	 * Returns the id of the handler instance
	 * @return
	 */
	String getId();
	
	/**
	 * Returns the connected client count
	 * @return
	 */
	int getClientCount();
	
	/**
	 * Returns the rt config
	 * @return
	 */
	RTConfig getConfig();
	
	/**
	 * Binds an observable to the rt instance
	 * @param obs
	 * @return
	 */
	<O extends Observable<T>,T> O bind(O obs, String changeId);

	/**
	 * Binds an observable list to the rt instance
	 * @param obs
	 * @return
	 */
	<O extends ObservableList<T>,T> O bind(O obs, String changeId);

}
