package li.rudin.rt.api.observable.computed;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

import li.rudin.rt.api.observable.Listener;
import li.rudin.rt.api.observable.base.ObservableGetter;

public class Computed<T> implements ObservableAccessor, Listener<Object>, ObservableGetter<T>
{
	public Computed(ComputedValue<T> cv)
	{
		this.cv = cv;
		recompute();
	}
	
	private final ComputedValue<T> cv;
	private T value;
	
	private boolean registerObservables = true;
	
	/**
	 * Returns the current value
	 * @return
	 */
	@Override
	public T get()
	{
		return value;
	}
	
	/**
	 */
	private void recompute()
	{
		T oldValue = value;
		
		value = cv.compute(this);
		registerObservables = false;
		
		for (Listener<T> l: listeners)
			l.onChange(oldValue, value);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <V> V get(ObservableGetter<V> o)
	{
		if (registerObservables)
			o.addListener((Listener<V>) this);
		
		return o.get();
	}

	@Override
	public void onChange(Object oldValue, Object newValue)
	{
		recompute();
	}
	
	/**
	 * All local listeners
	 */
	private Set<Listener<T>> listeners = new CopyOnWriteArraySet<>();
	
	/**
	 * Adds a local listener
	 * @param l
	 */
	@Override
	public void addListener(Listener<T> l)
	{
		listeners.add(l);
	}
	
	/**
	 * Removes the local listener
	 * @param l
	 */
	@Override
	public void removeListener(Listener<T> l)
	{
		listeners.remove(l);
	}

	@Override
	public String toString()
	{
		return "Computed [cv=" + cv + ", value=" + value + ", listeners="
				+ listeners + "]";
	}
}
