package io.rudin.rt.api;

import io.rudin.rt.spi.RTServerProvider;

import java.util.Iterator;
import java.util.ServiceLoader;

public class RT
{
	
	static
	{
		Iterator<RTServerProvider> it = ServiceLoader.load(RTServerProvider.class).iterator();
		
		if (it.hasNext())
			provider = it.next();
		else
			throw new ExceptionInInitializerError("No RTServerProvider found (is rt-core in the classpath?)");
	}
	
	private static final RTServerProvider provider;
	
	/**
	 * Returns the rt serverprovider from the spi
	 * @return
	 */
	public static RTServerProvider getProvider()
	{
		return provider;
	}
	
	
	/**
	 * The default id for the RT Handler
	 */
	public static final String DEFAULT_ID = "default";

}
