package io.rudin.rt.api;

import io.rudin.rt.api.config.RTConfig;
import io.rudin.rt.api.filter.RTFilter;
import io.rudin.rt.api.listener.RTClientListener;
import io.rudin.rt.api.observable.Observable;
import io.rudin.rt.api.observable.list.ObservableList;

import java.util.List;
import java.util.Map;

public interface RTServer extends RTUpdater
{

	/**
	 * Returns the map with cached event data
	 * @return
	 */
	Map<String, Object> getCachedEvents();
	
	/**
	 * Sets a filter instance
	 * @param filter
	 */
	void setFilter(RTFilter filter);
	
	/**
	 * Returns the set filter
	 * @return
	 */
	RTFilter getFilter();
	
	/**
	 * Returns the id of the handler instance
	 * @return
	 */
	String getId();

	/**
	 * Returns the rt config
	 * @return
	 */
	RTConfig getConfig();
	
	/**
	 * Adds a client listener
	 * @param listener
	 */
	void addClientListener(RTClientListener listener);

	/**
	 * Returns all client listeners
	 * @return
	 */
	List<RTClientListener> getClientListeners();
	
	/**
	 * Binds an observable to the rt instance
	 * @param obs
	 * @return
	 */
	<O extends Observable<T>,T> O bind(O obs, String path);

	/**
	 * Binds an observable list to the rt instance
	 * @param obs
	 * @return
	 */
	<O extends ObservableList<T>,T> O bind(O obs, String path);
	

}
