
	/**
	 * RT Channel
	 */
	RT.Channel = function(url, cfg){
		
		var localTransports = Object.keys(RT.transports);
		
		/**
		 * Default config
		 */
		this.cfg = cfg = RT.extend({
			/**
			 * fatal error callback
			 */
			onError: function(msg){},
			
			/**
			 * Log function
			 */
			log: function(level, msg){},
			
			/**
			 * All enabled transports
			 */
			transports: localTransports,
			
			/**
			 * Websocket config
			 */
			websocket: {
				url: location.protocol.replace("http", "ws") + "//" + location.host + location.pathname.substring(0, location.pathname.lastIndexOf("/")+1) + "rt/websocket"
			}
			
			//TODO: onConnection loss
		}, cfg);
		
		
		cfg.log("INFO", "RT version: " + RT.version);
		cfg.log("INFO", "RT Instance created with url: " + url + " and enabled transports: " + cfg.transports);
		
		/**
		 * Self reference
		 */
		var self = this;

		/**
		 * Event handler
		 */
		this.events = new RT.Events;
		
		//Map event functions to parent
		this.on = this.events.on.bind(this.events);
		this.off = this.events.off.bind(this.events);
		this.once = this.events.once.bind(this.events);
		this.fire = this.events.fire.bind(this.events);
		
		/**
		 * Close handlers
		 */
		this.closeHandlers = [];
		
		this.close = function(){
			cfg.log("INFO", "Stopping RT instance");
			self.closeHandlers.forEach(function(h){ h(); });
		};
		
		
		cfg.log("DEBUG", "Quering status from server");
		
		RT.getJSON(url)
		.then(function(status){
			
			var availableTransports = status.transports;
			
			if (status.version !== RT.version)
				cfg.log("WARN", "Version mismatch, js=" + RT.version + " server=" + status.version);
			
			cfg.log("DEBUG", "Available server-transports: " + availableTransports);
			
			if (!availableTransports)
				return cfg.onError("invalid transports: " + availableTransports);
			
			/**
			 * Check enabled transport
			 */
			var checkTransport = function(name){
				return availableTransports.indexOf(name) >= 0 && cfg.transports.indexOf(name) >= 0;
			};
			
			var transportList = [];
			
			//TODO: more dynamic
			
			if (checkTransport("longpoll")){
				//Longpoll
				cfg.log("DEBUG", "Enabling longpoll transport");
				transportList.push(RT.transports.longpoll);
			}
			
			if (checkTransport("sse")){
				//SSE
				cfg.log("DEBUG", "Enabling sse transport");
				transportList.push(RT.transports.sse);
			}

			if (checkTransport("websocket")){
				//Websocket
				cfg.log("DEBUG", "Enabling websocket transport");
				transportList.push(RT.transports.websocket);
			}
			
			var transport = undefined;

			cfg.log("DEBUG", "My id: " + status.clientId);

			var createTransport = function(){
				
				if (transportList.length == 0){
					cfg.log("ERROR", "No more transports");
					cfg.onError("No more transports");
					return;
				}
								
				transport = transportList.pop();
				
				var instance = new transport(url, self, cfg, createTransport);
			};
			
			//Create initial transport
			createTransport();
		})
		.fail(function(status){
			cfg.log("ERROR", "Connection error: " + msg);
			cfg.onError("Connection error: " + msg);
		});

	};

