	RT.Events = function(){
		
		/**
		 * listener map: { "": [], "x": [], "x/y": [] }
		 */
		this.listenerMap = {};
	};
	
	/**
	 * Fires an event
	 */
	RT.Events.prototype.fire = function(path, event){
		
		var self = this;
		
		var currentPath = path;
		
		
		//Fire exact match
		if (this.listenerMap[path]){
			this.listenerMap[path].forEach(function(listener){
				listener(event, path);
			});
		}

		
	}
	
	/**
	 * Registers a listener
	 */
	RT.Events.prototype.on = function(path, listener){
		
		if (!this.listenerMap[path])
			//Create new array
			this.listenerMap[path] = [];
			
		var list = this.listenerMap[path];

		list.push(listener);

		var self = this;
		
		/**
		 * Return event management object
		 */
		return {
			off: function(){
				self.off(path, listener);
			}
		}
	};
	
	/**
	 * Unregisters a listener
	 */
	RT.Events.prototype.off = function(path, listener){
		if (!this.listenerMap[path])
			//Create new array
			this.listenerMap[path] = [];
			
		var list = this.listenerMap[path],
			index = list.indexOf(listener);
		
		if (index >= 0)
			list.splice(index, 1);
	};
	
	/**
	 * Register for one-time event
	 */
	RT.Events.prototype.once = function(path, listener){
		var self = this;
		
		var handle = this.on(path, function(){
			listener.apply(this, arguments);
			handle.off();
		});
	};
