
	/**
	 * ajax json request
	 * http://youmightnotneedjquery.com/
	 */
	RT.getJSON = function(url){
		
		var successHandlers = [],
			failHandlers = [];
		
		var request = new XMLHttpRequest();
		request.open('GET', url, true);

		request.onload = function(){
			if (request.status >= 200 && request.status < 400){
				// Success!
				var data = JSON.parse(request.responseText);
				successHandlers.forEach(function(s){ s(data); });
			} else {
				// We reached our target server, but it returned an error
				failHandlers.forEach(function(h){ f(request.status); });
			}
		};

		request.onerror = function(){
			failHandlers.forEach(function(h){ f(); });
		};

		request.send();
		
		//Return pseudo-promise
		var promise = {
			then: function(s, f){
				successHandlers.push(s);
				if (typeof f === 'function')
					failHandlers.push(f);
				return promise;
			},
			fail: function(f){
				failHandlers.push(f);
				return promise;
			},
			always: function(a){
				successHandlers.push(a);
				failHandlers.push(a);
			}
		};
		
		return promise;
	};

