
	/**
	 * Long poll implementation
	 */
	RT.transports.longpoll = function(url, rt, cfg, failover){
		
		rt.cfg.log("DEBUG", "Creating longpoll connection to: " + url);
		
		var run = true,
			first = true;
		
		
		/**
		 * Custom close() function
		 */
		rt.closeHandlers.push(function(){ run = false; });
		
		var doRequest = function(){
			RT.getJSON(url + "?mode=longpoll" + (first ? "&flush" : ""))
			.then(function(list){
				//Clear first flag
				first = false;
				
				//Pass to rt
				if (list instanceof Array)
					list.forEach(function(e){
						rt.fire(e.path, e.data);
					});
				
			})
			.always(function(){
				
				if (run)
					//Restart
					doRequest();
			});
		};
		
		doRequest();
		
	};

