
	/**
	 * SSE implementation
	 */
	if (typeof(EventSource) === "function"){
		RT.transports.sse = function(url, rt, cfg, failover){
			
			rt.cfg.log("DEBUG", "Creating eventsource connection to: " + url);
	
			
			var src = new EventSource(url + "?mode=sse"),
				initReceived = false,
				run = true;
		
			/**
			 * Custom close() function
			 */
			rt.closeHandlers.push(function(){
				src.close();
				run = false;
			});
			
			var to = setTimeout(function(){
				//error timeout
				
				//fallback to longpoll
				src.close();
				
				if (run)
					//not stopped explicitly, so go to failover
					failover();
				
			}, 1500);
			
			src.addEventListener("rt", function(e){
				var data = JSON.parse(e.data);
					
				if (!initReceived){
					//init message received
					rt.cfg.log("DEBUG", "SSE Init received");
					initReceived = true;
					clearTimeout(to);
				}
				
				rt.fire(data.path, data.data);
			});
	
		};
	}
