
	/**
	 * Websocket implementation
	 */
	if (typeof(WebSocket) === "function"){
		RT.transports.websocket = function(url, rt, cfg, failover){
			
			rt.cfg.log("DEBUG", "Creating websocket connection to: " + cfg.websocket.url);
			
			var ws = new WebSocket(cfg.websocket.url),
				initReceived = false,
				run = true;
		
			/**
			 * Custom close() function
			 */
			rt.closeHandlers.push(function(){
				ws.close();
				run = false;
			});
			
			var to = setTimeout(function(){
				//error timeout
				
				//fallback to longpoll
				ws.close();
				
				if (run)
					//not stopped explicitly, so go to failover
					failover();
				
			}, 1500);
			
			ws.onmessage = function(e){
				var data = JSON.parse(e.data);
							
				if (!initReceived){
					//init message received
					rt.cfg.log("DEBUG", "Websocket Init received");
					initReceived = true;
					clearTimeout(to);
				}
		
				rt.fire(data.path, data.data);
			};
			
			ws.onopen = function(){
				rt.cfg.log("DEBUG", "Websocket open");
				ws.send("{ ready: true }");
			};
			
			ws.onerror = function(){
				rt.cfg.log("ERROR", "Websocket failed");
				if (run)
					failover();
			};
			
		};
	}
