package li.rudin.rt.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLoader
{

	private static final Logger logger = LoggerFactory.getLogger(PluginLoader.class);
	
	private static final List<Plugin> plugins = new ArrayList<>();
	
	static
	{
		Iterator<Plugin> it = ServiceLoader.load(Plugin.class).iterator();
		while (it.hasNext())
		{
			Plugin plugin = it.next();
			
			logger.debug("Loading plugin: {}", plugin);
			
			plugins.add(plugin);
		}
	}
	
	
	public static List<Plugin> getPlugins()
	{
		return plugins;
	}
	
}
