/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.rt.transport.websocket;

import java.util.List;
import java.util.Map;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import li.rudin.rt.api.RT;
import li.rudin.rt.core.client.ClientHook;
import li.rudin.rt.core.client.RTClientImpl;
import li.rudin.rt.core.container.ObjectContainer;
import li.rudin.rt.core.server.RTServerImpl;
import li.rudin.rt.core.util.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTEndpoint
extends Endpoint
implements ClientHook {
    private static final Logger logger = LoggerFactory.getLogger(RTEndpoint.class);
    private int id;
    private RTServerImpl server;
    private RTClientImpl client;
    private RemoteEndpoint.Basic remote;

    public void onOpen(Session session, EndpointConfig config) {
        Map parameters = session.getPathParameters();
        this.id = Integer.parseInt((String)parameters.get("id"));
        String rtId = (String)parameters.get("rtId");
        logger.debug("Session with id: {}, rtId: {}", (Object)this.id, (Object)rtId);
        this.server = (RTServerImpl)RT.getProvider().getInstance(rtId);
        this.client = this.server.get(this.id);
        this.remote = session.getBasicRemote();
        this.rtMessageHook(null);
        this.client.setHook((ClientHook)this);
    }

    public void rtMessageHook(ObjectContainer o) {
        try {
            List list = this.client.copyAndClear(this.server.getFilter());
            for (ObjectContainer c : list) {
                String json = JSON.toJson((Object)c);
                this.remote.sendText(json);
            }
            this.server.get(this.id);
        }
        catch (Exception e) {
            logger.error("send", (Throwable)e);
            this.client.close();
        }
    }
}

