/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.webdoc.core.template;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import li.rudin.webdoc.core.callback.TransformerCallback;
import li.rudin.webdoc.core.template.TemplateTransformer;
import li.rudin.webdoc.core.transformer.Transformer;
import li.rudin.webdoc.core.transformer.impl.HTMLTransformer;
import li.rudin.webdoc.core.transformer.impl.MarkdownTransformer;
import li.rudin.webdoc.core.util.StreamUtil;

public class TransformFileVisitor
extends SimpleFileVisitor<Path> {
    private final Path targetPath;
    private final TemplateTransformer transformer;
    private final TransformerCallback callback;
    private static final Transformer[] MARKUP_TRANSFORMERS = new Transformer[]{new MarkdownTransformer(), new HTMLTransformer()};
    private Path sourcePath = null;

    public TransformFileVisitor(Path targetPath, TemplateTransformer transformer, TransformerCallback callback) {
        this.targetPath = targetPath;
        this.callback = callback;
        this.transformer = transformer;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        String baseDir = "";
        if (this.sourcePath == null) {
            this.sourcePath = dir;
        } else {
            Path relativePath = this.sourcePath.relativize(dir);
            Files.createDirectories(this.targetPath.resolve(relativePath), new FileAttribute[0]);
            for (int i = 0; i < relativePath.getNameCount(); ++i) {
                baseDir = baseDir + "../";
            }
        }
        this.transformer.getVariables().put("basedir", baseDir);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        for (Transformer t : MARKUP_TRANSFORMERS) {
            if (!file.toString().endsWith(t.getFileExtension())) continue;
            File sourceFile = file.toFile();
            FileInputStream inputStream = new FileInputStream(sourceFile);
            String inputString = StreamUtil.streamToString(inputStream);
            String string = t.transform(inputString);
            String output = this.transformer.transform(string);
            Path relativeFilePath = this.sourcePath.relativize(file);
            String newFileString = relativeFilePath.toString().substring(0, relativeFilePath.toString().length() - t.getFileExtension().length());
            newFileString = newFileString + t.getTargetFileExtension();
            Path newPath = this.targetPath.resolve(newFileString);
            this.callback.callback(file.toString(), newPath.toString());
            File newFile = newPath.toFile();
            newFile.getParentFile().mkdirs();
            FileOutputStream outputStream = new FileOutputStream(newFile);
            outputStream.write(output.getBytes());
            inputStream.close();
            outputStream.close();
            return FileVisitResult.CONTINUE;
        }
        Files.copy(file, this.targetPath.resolve(this.sourcePath.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
        return FileVisitResult.CONTINUE;
    }
}

