package li.rudin.webdoc.core.template;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;

import li.rudin.webdoc.core.callback.TransformerCallback;

/**
 * http://stackoverflow.com/questions/6214703/copy-entire-directory-contents-to-another-directory
 * @author user
 *
 */
public class TemplateDirCopyVisitor extends SimpleFileVisitor<Path>
{
	private final Path targetPath;
	private final TransformerCallback callback;
	
	private Path sourcePath = null;
	
	public TemplateDirCopyVisitor(Path targetPath, TransformerCallback callback)
	{
		this.targetPath = targetPath;
		this.callback = callback;
	}

	@Override
	public FileVisitResult preVisitDirectory(final Path dir, final BasicFileAttributes attrs) throws IOException
	{
		if (sourcePath == null)
			sourcePath = dir;
		else
			Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)));
		
		return FileVisitResult.CONTINUE;
	}

	@Override
	public FileVisitResult visitFile(final Path file, final BasicFileAttributes attrs) throws IOException
	{
		Path relativePath = sourcePath.relativize(file);
		
		if (relativePath.toString().equals("template.html"))
			//Skip template
			return FileVisitResult.CONTINUE;
		
		Path absoluteTargetPath = targetPath.resolve(relativePath);
		
		callback.callback(file.toString(), absoluteTargetPath.toString());
		
		Files.copy(file, absoluteTargetPath, StandardCopyOption.REPLACE_EXISTING);
		
		return FileVisitResult.CONTINUE;
	}
}