/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.webdoc.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import li.rudin.webdoc.core.callback.TransformerCallback;
import li.rudin.webdoc.core.template.TemplateDirCopyVisitor;
import li.rudin.webdoc.core.template.TemplateTransformer;
import li.rudin.webdoc.core.template.TransformFileVisitor;

public class WebdocTransformer {
    private final String templateDir;
    private final String contentDir;
    private final Map<String, String> variables = new HashMap<String, String>();

    public WebdocTransformer(String templateDir, String contentDir) {
        this.contentDir = contentDir;
        this.templateDir = templateDir;
    }

    public void transform(String targetDir, TransformerCallback callback) throws IOException {
        FileInputStream templateInputStream = new FileInputStream(this.templateDir + "/template.html");
        TemplateTransformer templateTransformer = new TemplateTransformer(templateInputStream, this.getVariables());
        templateInputStream.close();
        Files.walkFileTree(Paths.get(this.templateDir, new String[0]), new TemplateDirCopyVisitor(Paths.get(targetDir, new String[0]), callback));
        Files.walkFileTree(Paths.get(this.contentDir, new String[0]), new TransformFileVisitor(Paths.get(targetDir, new String[0]), templateTransformer, callback));
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }
}

