package li.rudin.webdoc.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

import li.rudin.webdoc.core.callback.TransformerCallback;
import li.rudin.webdoc.core.template.TemplateDirCopyVisitor;
import li.rudin.webdoc.core.template.TemplateTransformer;
import li.rudin.webdoc.core.template.TransformFileVisitor;

public class WebdocTransformer
{

	public WebdocTransformer(String templateDir, String contentDir)
	{
		this.contentDir = contentDir;
		this.templateDir = templateDir;
	}
	
	private final String templateDir, contentDir;
	
	private final Map<String, String> variables = new HashMap<>();
	
	public void transform(String targetDir, TransformerCallback callback) throws IOException
	{
		//Create template transformer
		FileInputStream templateInputStream = new FileInputStream(templateDir + "/template.html");
		TemplateTransformer templateTransformer = new TemplateTransformer(templateInputStream, getVariables());
		templateInputStream.close();
		
		//Copy files from template dir
		Files.walkFileTree(Paths.get(templateDir), new TemplateDirCopyVisitor(Paths.get(targetDir), callback));
		
		//transform content
		Files.walkFileTree(Paths.get(contentDir), new TransformFileVisitor(Paths.get(targetDir), templateTransformer, callback));
		
	}

	public Map<String, String> getVariables()
	{
		return variables;
	}
	
}
