package li.rudin.webdoc.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtil
{
	/**
	 * Copies an input stream to the output stream
	 * @param is
	 * @param os
	 * @throws IOException
	 */
	public static long streamCopy(InputStream is, OutputStream os) throws IOException
	{
		long size = 0;
		byte[] buffer = new byte[32768];
		int len;
		while ((len = is.read(buffer)) > 0)
		{
			os.write(buffer, 0, len);
			size += len;
		}
		
		return size;
	}
	
	public static String streamToString(InputStream in) throws IOException
	{
		ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
		streamCopy(in, outputStream);
		return outputStream.toString();
	}
	
}
