package li.rudin.webdoc.core.transformer.impl;

import li.rudin.webdoc.core.transformer.StringTransformer;

import org.pegdown.PegDownProcessor;

public class MarkdownTransformer extends StringTransformer
{
	private final PegDownProcessor proc = new PegDownProcessor();

	@Override
	public String getFileExtension()
	{
		return "md";
	}

	@Override
	public String getTargetFileExtension()
	{
		return "html";
	}

	@Override
	public String transform(String str)
	{
		return proc.markdownToHtml(str);
	}

}
