package li.rudin.webdoc.core.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import li.rudin.webdoc.util.StreamUtil;


public class TemplateTransformer
{
	
	public TemplateTransformer(InputStream templateInput, Map<String, String> variables) throws IOException
	{
		this(StreamUtil.streamToString(templateInput), variables);
	}
	
	public TemplateTransformer(String template)
	{
		this(template, new HashMap<String, String>());
	}
		
	public TemplateTransformer(String template, Map<String, String> variables)
	{
		this.template = template;
		this.variables = variables;
	}
		
	private final String template;
	private final Map<String, String> variables;

	private String parseProperties(String in)
	{
		String ret = in;
		for (Map.Entry<String, String> entry: getVariables().entrySet())
			ret = replaceVar(ret, entry.getKey(), entry.getValue());
		
		//TODO
		
		
		return ret;
	}
	
	private String replaceVar(String in, String name, String content)
	{
		return in
				//Replace variables
				.replaceAll("\\{\\{" + name + "\\}\\}", content)
				//Replaced commented variables
				.replaceAll("%%" + name + "%%", "{{"+name+"}}");
	}
	
	/**
	 * Applies the template on the input string
	 * @param input
	 * @return
	 */
	public String transform(String input)
	{
		String str = template;
		str = replaceVar(str, "content", input);
		str = parseProperties(str);
		return str;
	}
	
	/**
	 * Replaces the variables on an input string
	 * @param input
	 * @return
	 */
	public String replaceVariables(String input)
	{
		return parseProperties(input);
	}

	public Map<String, String> getVariables()
	{
		return variables;
	}
	
}
