/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.webdoc.core.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import li.rudin.webdoc.util.StreamUtil;

public class TemplateTransformer {
    private final String template;
    private final Map<String, String> variables;

    public TemplateTransformer(InputStream templateInput, Map<String, String> variables) throws IOException {
        this(StreamUtil.streamToString((InputStream)templateInput), variables);
    }

    public TemplateTransformer(String template) {
        this(template, new HashMap<String, String>());
    }

    public TemplateTransformer(String template, Map<String, String> variables) {
        this.template = template;
        this.variables = variables;
    }

    private String parseProperties(String in) {
        String ret = in;
        for (Map.Entry<String, String> entry : this.getVariables().entrySet()) {
            ret = this.replaceVar(ret, entry.getKey(), entry.getValue());
        }
        return ret;
    }

    private String replaceVar(String in, String name, String content) {
        return in.replaceAll("\\{\\{" + name + "\\}\\}", content).replaceAll("%%" + name + "%%", "{{" + name + "}}");
    }

    public String transform(String input) {
        String str = this.template;
        str = this.replaceVar(str, "content", input);
        str = this.parseProperties(str);
        return str;
    }

    public String replaceVariables(String input) {
        return this.parseProperties(input);
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }
}

