package li.rudin.webdoc.plugin;

import java.util.Map;

import li.rudin.webdoc.core.WebdocTransformer;
import li.rudin.webdoc.core.callback.TransformerCallback;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate")
public class WebdocMojo extends AbstractMojo implements TransformerCallback
{

	//http://olamy.blogspot.fr/2012/05/java5-annotations-support-for-maven.html
	//https://cwiki.apache.org/confluence/display/MAVEN/Java+5+Annotations+for+Plugins
	
	@Parameter(defaultValue="${project.build.directory}/../src/webdoc/template.html") String template;
	@Parameter(defaultValue="${project.build.directory}/../src/webdoc") String contentDir;
	
	@Parameter(defaultValue="${project.build.directory}/webdoc") String outputDir;
	
	@Parameter Map<String, String> variables;

	@Component MavenProject project;
	
	@Override
	public void execute() throws MojoExecutionException, MojoFailureException
	{
		
		getLog().info("Generating Webdoc: " + contentDir);

		try
		{
			WebdocTransformer transformer = new WebdocTransformer(
					template,
					contentDir
			);
			
			Map<String, String> vars = transformer.getVariables();
			
			if (variables != null)
				//put configured variables
				vars.putAll(variables);
			
			for (Map.Entry<Object, Object> entry: project.getProperties().entrySet())
				//Put property variables
				vars.put(entry.getKey().toString(), entry.getValue().toString());

			//Put build variables
			vars.put("project.version", project.getVersion());
			vars.put("project.name", project.getName());
			
			transformer.transform(outputDir, this);
		}
		catch (Exception e)
		{
			throw new MojoExecutionException("execute", e);
		}
	}

	@Override
	public void callback(String source, String target)
	{
		getLog().info(source + " -> " + target);
	}

}
