/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.webdoc.plugin;

import java.util.Map;
import li.rudin.webdoc.core.WebdocTransformer;
import li.rudin.webdoc.core.callback.TransformerCallback;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate")
public class WebdocMojo
extends AbstractMojo
implements TransformerCallback {
    @Parameter(defaultValue="${project.build.directory}/../src/webdoc/template.html")
    String template;
    @Parameter(defaultValue="${project.build.directory}/../src/webdoc")
    String contentDir;
    @Parameter(defaultValue="${project.build.directory}/webdoc")
    String outputDir;
    @Parameter
    Map<String, String> variables;
    @Component
    MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Generating Webdoc: " + this.contentDir));
        try {
            WebdocTransformer transformer = new WebdocTransformer(this.template, this.contentDir);
            Map vars = transformer.getVariables();
            if (this.variables != null) {
                vars.putAll(this.variables);
            }
            for (Map.Entry<Object, Object> entry : this.project.getProperties().entrySet()) {
                vars.put(entry.getKey().toString(), entry.getValue().toString());
            }
            vars.put("project.version", this.project.getVersion());
            vars.put("project.name", this.project.getName());
            transformer.transform(this.outputDir, (TransformerCallback)this);
        }
        catch (Exception e) {
            throw new MojoExecutionException("execute", e);
        }
    }

    public void callback(String source, String target) {
        this.getLog().info((CharSequence)(source + " -> " + target));
    }
}

