/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.webdoc.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import li.rudin.webdoc.core.WebdocTransformer;
import li.rudin.webdoc.core.callback.TransformerCallback;
import li.rudin.webdoc.core.util.StreamUtil;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate")
public class GenerateMojo
extends AbstractMojo
implements TransformerCallback {
    @Parameter(defaultValue="${project.build.directory}/../src/webdoc/template")
    String templateDir;
    @Parameter
    String templateArtifact;
    @Parameter(defaultValue="${project.build.directory}/../src/webdoc/content")
    String contentDir;
    @Parameter(defaultValue="${project.build.directory}/webdoc")
    String outputDir;
    @Parameter
    Map<String, String> variables;
    @Component
    MavenProject project;
    @Parameter(defaultValue="${localRepository}")
    ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.dependencies}")
    List<Dependency> dependencies;
    @Component
    ArtifactFactory artifactFactory;
    @Component
    ArtifactResolver resolver;
    @Component
    ArtifactMetadataSource artifactMetadataSource;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    List<Repository> remoteRepositories;

    private void unzipContents(File zipFile, String dir) throws ZipException, IOException {
        Log logger = this.getLog();
        File targetDir = new File(dir);
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry element = entries.nextElement();
            InputStream inputStream = zip.getInputStream(element);
            File targetFile = new File(targetDir, element.getName());
            if (element.getName().startsWith("META-INF")) continue;
            if (element.isDirectory()) {
                targetFile.mkdirs();
                continue;
            }
            logger.info((CharSequence)("Extracting to: " + targetFile.getAbsolutePath()));
            FileOutputStream outputStream = new FileOutputStream(targetFile);
            StreamUtil.streamCopy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.close();
            inputStream.close();
        }
        zip.close();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log logger = this.getLog();
        logger.info((CharSequence)("Generating Webdoc: " + this.contentDir));
        try {
            if (this.templateArtifact != null) {
                String[] parts = this.templateArtifact.split("[:]");
                if (parts.length != 3) {
                    throw new IllegalArgumentException("template artifact must be in form: <groupId>:<artifactId>:<version>");
                }
                String groupId = parts[0];
                String artifactId = parts[1];
                String version = parts[2];
                Artifact artifact = this.artifactFactory.createArtifact(groupId, artifactId, version, "compile", "jar");
                this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                File artifactFile = artifact.getFile();
                logger.info((CharSequence)("Template artifact: " + artifactFile.getAbsolutePath()));
                this.templateDir = this.project.getBuild().getDirectory() + "/webdoc-template";
                this.unzipContents(artifactFile, this.templateDir);
            }
            WebdocTransformer transformer = new WebdocTransformer(this.templateDir, this.contentDir);
            Map vars = transformer.getVariables();
            if (this.variables != null) {
                vars.putAll(this.variables);
            }
            for (Map.Entry<Object, Object> entry : this.project.getProperties().entrySet()) {
                vars.put(entry.getKey().toString(), entry.getValue().toString());
            }
            vars.put("project.version", this.project.getVersion());
            vars.put("project.name", this.project.getName());
            transformer.transform(this.outputDir, (TransformerCallback)this);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new MojoExecutionException("execute", e);
        }
    }

    public void callback(String source, String target) {
        this.getLog().info((CharSequence)(source + " -> " + target));
    }
}

