/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.webdoc.plugin;

import java.util.List;
import java.util.Map;
import li.rudin.webdoc.core.WebdocTransformer;
import li.rudin.webdoc.core.callback.TransformerCallback;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="generate")
public class GenerateMojo
extends AbstractMojo
implements TransformerCallback {
    @Parameter(defaultValue="${project.build.directory}/../src/webdoc/template")
    String templateDir;
    @Parameter
    String templateArtifact;
    @Parameter(defaultValue="${project.build.directory}/../src/webdoc/content")
    String contentDir;
    @Parameter(defaultValue="${project.build.directory}/webdoc")
    String outputDir;
    @Parameter
    Map<String, String> variables;
    @Component
    MavenProject project;
    @Parameter(defaultValue="${localRepository}")
    ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.dependencies}")
    List<Dependency> dependencies;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    List<Repository> remoteRepositories;
    @Parameter(defaultValue="${session}")
    MavenSession session;
    @Component
    BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log logger = this.getLog();
        logger.info((CharSequence)("Generating Webdoc: " + this.contentDir));
        try {
            if (this.templateArtifact != null) {
                String[] parts = this.templateArtifact.split("[:]");
                if (parts.length != 3) {
                    throw new IllegalArgumentException("template artifact must be in form: <groupId>:<artifactId>:<version>");
                }
                String groupId = parts[0];
                String artifactId = parts[1];
                String version = parts[2];
                this.templateDir = this.project.getBuild().getDirectory() + "/webdoc-template";
                MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"2.8")), (String)MojoExecutor.goal((String)"unpack"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)this.templateDir), MojoExecutor.element((String)MojoExecutor.name((String)"artifactItems"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifactItem"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"groupId", (String)groupId), MojoExecutor.element((String)"artifactId", (String)artifactId), MojoExecutor.element((String)"version", (String)version)})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
            }
            WebdocTransformer transformer = new WebdocTransformer(this.templateDir, this.contentDir);
            Map vars = transformer.getVariables();
            if (this.variables != null) {
                vars.putAll(this.variables);
            }
            for (Map.Entry<Object, Object> entry : this.project.getProperties().entrySet()) {
                vars.put(entry.getKey().toString(), entry.getValue().toString());
            }
            vars.put("project.version", this.project.getVersion());
            vars.put("project.name", this.project.getName());
            transformer.transform(this.outputDir, (TransformerCallback)this);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new MojoExecutionException("execute", e);
        }
    }

    public void callback(String source, String target) {
        this.getLog().info((CharSequence)(source + " -> " + target));
    }
}

