/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.webdoc.plugin.visitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import li.rudin.webdoc.plugin.UploadMojo;

public class FTPUploadFileVisitor
extends SimpleFileVisitor<Path> {
    private Path sourcePath = null;
    private final UploadMojo parent;

    public FTPUploadFileVisitor(UploadMojo parent) {
        this.parent = parent;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.sourcePath == null) {
            this.sourcePath = dir;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path relativePath = this.sourcePath.relativize(file);
        File sourceFile = file.toFile();
        if (sourceFile.isFile()) {
            FileInputStream inputStream = new FileInputStream(sourceFile);
            this.parent.upload(relativePath.toString().replace("\\", "/"), inputStream);
            inputStream.close();
        }
        return FileVisitResult.CONTINUE;
    }
}

