/*
 * Decompiled with CFR 0.152.
 */
package li.rudin.webdoc.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.List;
import li.rudin.webdoc.plugin.visitor.FTPUploadFileVisitor;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

@Mojo(name="upload")
public class UploadMojo
extends AbstractMojo {
    @Parameter(required=true)
    List<File> files;
    @Parameter(required=true)
    String remoteHost;
    @Parameter(defaultValue="")
    String remoteDir;
    @Parameter(defaultValue="21")
    int remotePort;
    @Parameter
    String username;
    @Parameter
    String password;
    @Parameter
    String serverId;
    @Component
    Settings settings;
    private FTPClient client;
    private String currentDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log logger = this.getLog();
        if (this.files == null || this.files.size() == 0) {
            return;
        }
        try {
            this.client = new FTPClient();
            this.client.connect(this.remoteHost, this.remotePort);
            boolean connected = false;
            if (this.serverId != null) {
                Server server = this.settings.getServer(this.serverId);
                if (server == null) {
                    logger.error((CharSequence)("server config not found: " + this.serverId));
                }
                connected = this.client.login(server.getUsername(), server.getPassword());
            } else if (this.username != null && this.password == null) {
                connected = this.client.login(this.username, "");
            } else if (this.username != null && this.password != null) {
                connected = this.client.login(this.username, this.password);
            }
            if (!connected) {
                throw new IllegalArgumentException("not connected!");
            }
            logger.info((CharSequence)("Connected to: " + this.remoteHost + ":" + this.remotePort));
            this.client.setFileType(2);
            this.client.enterLocalPassiveMode();
            if (this.remoteDir.length() > 0 && !this.remoteDir.endsWith("/")) {
                this.remoteDir = this.remoteDir + "/";
            }
            for (File file : this.files) {
                if (file.isDirectory()) {
                    Files.walkFileTree(file.toPath(), new FTPUploadFileVisitor(this));
                    continue;
                }
                if (!file.isFile()) continue;
                FileInputStream inputStream = new FileInputStream(file);
                this.upload(file.getName(), inputStream);
                inputStream.close();
            }
            this.client.disconnect();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new IllegalArgumentException("upload", e);
        }
    }

    private void changeDir(String dir) throws IOException {
        if (dir.equals(this.currentDir)) {
            return;
        }
        Log logger = this.getLog();
        logger.info((CharSequence)("Changing dir: " + dir));
        if (this.currentDir != null) {
            String[] dirParts = this.currentDir.split("/");
            for (int i = 0; i < dirParts.length; ++i) {
                if (this.client.changeToParentDirectory()) continue;
                throw new IllegalArgumentException("could not change to parent dir");
            }
        }
        for (String part : dir.split("/")) {
            if (this.client.changeWorkingDirectory(part)) continue;
            int result = this.client.mkd(part);
            if (result != 257) {
                throw new IllegalArgumentException("could not create path: " + part);
            }
            if (this.client.changeWorkingDirectory(part)) continue;
            throw new IllegalArgumentException("could not chnage to dir: " + part);
        }
        this.currentDir = dir;
    }

    public void upload(String targetName, InputStream file) throws IOException {
        Log logger = this.getLog();
        String fullName = this.remoteDir + targetName;
        String fileName = targetName;
        if (fullName.contains("/")) {
            int lastSlashIndex = fullName.lastIndexOf("/");
            String dir = fullName.substring(0, lastSlashIndex);
            this.changeDir(dir);
            fileName = fullName.substring(lastSlashIndex + 1, fullName.length());
        }
        logger.info((CharSequence)("Uploading: " + fullName + " (" + fileName + ")"));
        this.client.storeFile(fileName, file);
    }
}

