package li.rudin.webdoc.plugin.visitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

import li.rudin.webdoc.plugin.UploadMojo;

/**
 * http://stackoverflow.com/questions/6214703/copy-entire-directory-contents-to-another-directory
 * @author user
 *
 */
public class FTPUploadFileVisitor extends SimpleFileVisitor<Path>
{
	private Path sourcePath = null;

	public FTPUploadFileVisitor(UploadMojo parent)
	{
		this.parent = parent;
	}

	private final UploadMojo parent;

	@Override
	public FileVisitResult preVisitDirectory(final Path dir, final BasicFileAttributes attrs) throws IOException
	{
		if (sourcePath == null)
			sourcePath = dir;

		return FileVisitResult.CONTINUE;
	}

	@Override
	public FileVisitResult visitFile(final Path file, final BasicFileAttributes attrs) throws IOException
	{
		Path relativePath = sourcePath.relativize(file);


		File sourceFile = file.toFile();
		if (sourceFile.isFile())
		{
			FileInputStream inputStream = new FileInputStream(sourceFile);

			parent.upload(relativePath.toString().replace("\\", "/"), inputStream);

			inputStream.close();
		}

		return FileVisitResult.CONTINUE;
	}
}