/*
 * Decompiled with CFR 0.152.
 */
package lt.dvim.hof;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.Terminated;
import akka.stream.Graph;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.RunnableGraph;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.stream.scaladsl.StreamConverters$;
import akka.util.ByteString$;
import cats.Show;
import cats.data.NonEmptyList;
import cats.effect.ContextShift;
import cats.effect.ExitCode;
import cats.effect.ExitCode$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.IOApp;
import cats.effect.Timer;
import com.monovore.decline.Command;
import com.monovore.decline.Command$;
import com.monovore.decline.Help;
import fansi.Color$;
import fansi.Str$;
import fansi.Underlined$;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import lt.dvim.hof.BuildInfo$;
import lt.dvim.hof.Commands;
import lt.dvim.hof.Commands$;
import lt.dvim.hof.Commands$Version$;
import lt.dvim.hof.History;
import lt.dvim.hof.History$;
import lt.dvim.hof.History$Entry$;
import lt.dvim.hof.IoAdapter$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Main$
implements IOApp {
    public static final Main$ MODULE$ = new Main$();
    private static final DateTimeFormatter BackupDatetimeFormat;
    private static volatile boolean bitmap$init$0;

    static {
        IOApp.$init$((IOApp)MODULE$);
        BackupDatetimeFormat = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
        bitmap$init$0 = true;
    }

    public void main(String[] args) {
        IOApp.main$((IOApp)this, (String[])args);
    }

    public ContextShift<IO> contextShift() {
        return IOApp.contextShift$((IOApp)this);
    }

    public Timer<IO> timer() {
        return IOApp.timer$((IOApp)this);
    }

    public final DateTimeFormatter BackupDatetimeFormat() {
        if (!bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/history-of-fishing/history-of-fishing/src/main/scala/Main.scala: 44");
        }
        return BackupDatetimeFormat;
    }

    public IO<ExitCode> run(List<String> args) {
        IO iO;
        Command command = Command$.MODULE$.apply("hof", "History of Fishing: tools for working with fish shell history files", true, Commands$.MODULE$.commands());
        Either either = command.parse(args, command.parse$default$2());
        if (either instanceof Right) {
            Right right = (Right)either;
            Commands.Command cmd = (Commands.Command)right.value();
            ActorSystem sys = ActorSystem$.MODULE$.apply();
            iO = this.onCommand(cmd, sys).guaranteeCase((Function1 & Serializable)x$1 -> IO$.MODULE$.fromFuture(IO$.MODULE$.pure((Object)sys.terminate().map((Function1 & Serializable)x$2 -> {
                Main$.$anonfun$run$2(x$2);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)sys.dispatcher())), MODULE$.contextShift()));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            Help e = (Help)left.value();
            iO = IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Predef$.MODULE$.println((Object)e.toString())).$times$greater(IO$.MODULE$.apply((Function0 & Serializable)() -> ExitCode$.MODULE$.Error()));
        } else {
            throw new MatchError((Object)either);
        }
        IO program = iO;
        return program.handleErrorWith((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (!(throwable instanceof NoSuchFileException)) {
                throw new MatchError((Object)throwable);
            }
            NoSuchFileException noSuchFileException = (NoSuchFileException)throwable;
            IO iO = IO$.MODULE$.apply((Function0 & Serializable)() -> {
                Predef$.MODULE$.println((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(25).append("|").append(Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply((CharSequence)"File not found:"))).append("\n                      |").append(Underlined$.MODULE$.On().apply(Str$.MODULE$.implicitApply((CharSequence)noSuchFileException.getFile()))).toString())));
                return ExitCode$.MODULE$.Error();
            });
            return iO;
        });
    }

    private IO<ExitCode> onCommand(Commands.Command c, ActorSystem sys) {
        IO iO;
        Commands.Command command = c;
        if (command instanceof Commands.Merge) {
            Commands.Merge merge = (Commands.Merge)command;
            NonEmptyList<Path> files = merge.files();
            RunnableGraph merged = History$.MODULE$.merge((List<Source<History.Entry, NotUsed>>)files.toList().map((Function1 & Serializable)path -> History$.MODULE$.entries((Path)path))).toMat((Graph)Sink$.MODULE$.foreach((Function1 & Serializable)e -> {
                Predef$.MODULE$.print((Object)((Show.ContravariantShow)Predef$.MODULE$.implicitly(History$Entry$.MODULE$.entryRepr())).show((Object)e));
                return BoxedUnit.UNIT;
            }), Keep$.MODULE$.right());
            iO = IoAdapter$.MODULE$.fromRunnableGraph(merged, sys).map((Function1 & Serializable)x$3 -> ExitCode$.MODULE$.Success());
        } else if (command instanceof Commands.ResolveConflicts) {
            Commands.ResolveConflicts resolveConflicts = (Commands.ResolveConflicts)command;
            Path directory = resolveConflicts.path();
            Path OriginalHistory = directory.resolve("fish_history");
            Path HistoryBackup = directory.resolve(new StringBuilder(17).append("fish_history.bak-").append(LocalDateTime.now().format(this.BackupDatetimeFormat())).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(30).append("Backing up current history as ").append(Color$.MODULE$.Green().apply(Str$.MODULE$.implicitApply((CharSequence)((Object)HistoryBackup).toString()))).toString());
            Files.move(OriginalHistory, HistoryBackup, new CopyOption[0]);
            Source conflictFiles = StreamConverters$.MODULE$.fromJavaStream((Function0 & Serializable)() -> Files.find(directory, 1, (path, x$4) -> ((Object)path).toString().contains("fish_history.sync-conflict-"), new FileVisitOption[0]));
            RunnableGraph resolver = ((Source)History$.MODULE$.merge((Source<Source<History.Entry, NotUsed>, NotUsed>)((Source)Source$.MODULE$.single((Object)HistoryBackup).concat((Graph)conflictFiles.alsoTo((Graph)Sink$.MODULE$.foreach((Function1 & Serializable)f -> {
                Predef$.MODULE$.println((Object)new StringBuilder(15).append("Resolving from ").append(Color$.MODULE$.Green().apply(Str$.MODULE$.implicitApply((CharSequence)((Object)f).toString()))).toString());
                return BoxedUnit.UNIT;
            }))).map((Function1 & Serializable)path -> History$.MODULE$.entries((Path)path)))).map((Function1 & Serializable)x$5 -> ((Show.ContravariantShow)Predef$.MODULE$.implicitly(History$Entry$.MODULE$.entryRepr())).show(x$5)).map((Function1 & Serializable)string -> ByteString$.MODULE$.apply(string))).toMat((Graph)FileIO$.MODULE$.toPath(OriginalHistory, FileIO$.MODULE$.toPath$default$2()), Keep$.MODULE$.right());
            iO = IoAdapter$.MODULE$.fromRunnableGraph(resolver, sys).$times$greater(IO$.MODULE$.pure((Object)ExitCode$.MODULE$.Success()));
        } else if (Commands$Version$.MODULE$.equals(command)) {
            iO = IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Predef$.MODULE$.println((Object)BuildInfo$.MODULE$.version())).$times$greater(IO$.MODULE$.pure((Object)ExitCode$.MODULE$.Success()));
        } else {
            throw new MatchError((Object)command);
        }
        return iO;
    }

    public static final /* synthetic */ void $anonfun$run$2(Terminated x$2) {
    }

    private Main$() {
    }
}

