/*
 * Decompiled with CFR 0.152.
 */
package ltd.dudu.dsrc;

import io.github.pigmesh.ai.deepseek.core.DeepSeekClient;
import io.github.pigmesh.ai.deepseek.core.chat.ChatCompletionRequest;
import io.github.pigmesh.ai.deepseek.core.chat.ChatCompletionResponse;
import io.github.pigmesh.ai.deepseek.core.chat.JsonArraySchema;
import io.github.pigmesh.ai.deepseek.core.chat.JsonBooleanSchema;
import io.github.pigmesh.ai.deepseek.core.chat.JsonEnumSchema;
import io.github.pigmesh.ai.deepseek.core.chat.JsonIntegerSchema;
import io.github.pigmesh.ai.deepseek.core.chat.JsonNumberSchema;
import io.github.pigmesh.ai.deepseek.core.chat.JsonObjectSchema;
import io.github.pigmesh.ai.deepseek.core.chat.JsonSchema;
import io.github.pigmesh.ai.deepseek.core.chat.JsonSchemaElement;
import io.github.pigmesh.ai.deepseek.core.chat.JsonStringSchema;
import io.github.pigmesh.ai.deepseek.core.chat.Message;
import io.github.pigmesh.ai.deepseek.core.chat.ResponseFormat;
import io.github.pigmesh.ai.deepseek.core.chat.ResponseFormatType;
import io.github.pigmesh.ai.deepseek.core.chat.SystemMessage;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ltd.dudu.dsrc.DeepSeek;
import ltd.dudu.dsrc.Modes;
import ltd.dudu.dsrc.SchemaGenerator;
import ltd.dudu.dsrc.internal.JsonSchemaGenerator;
import ltd.dudu.dsrc.pojo.DeepSeekOptions;
import ltd.dudu.dsrc.utils.DebugUtil;

public class DeepSeek4jImpl
implements DeepSeek {
    private final DeepSeekClient deepSeekClient;
    private SchemaGenerator schemaGenerator;

    public DeepSeek4jImpl(DeepSeekClient deepSeekClient) {
        this.deepSeekClient = deepSeekClient;
    }

    public DeepSeek4jImpl(DeepSeekClient deepSeekClient, SchemaGenerator schemaGenerator) {
        this.deepSeekClient = deepSeekClient;
        this.schemaGenerator = schemaGenerator == null ? new JsonSchemaGenerator() : schemaGenerator;
    }

    @Override
    public ChatCompletionResponse createChat(List<Message> messages, String topicPrompt, Modes mode, DeepSeekOptions options) {
        ChatCompletionRequest.Builder requestBuilder = ChatCompletionRequest.builder().model(mode.getName());
        ArrayList<Message> allMessages = new ArrayList<Message>();
        if (topicPrompt != null) {
            allMessages.add((Message)SystemMessage.from((String)topicPrompt));
        }
        allMessages.addAll(messages);
        requestBuilder.messages(allMessages);
        requestBuilder.responseFormat(ResponseFormatType.TEXT);
        DebugUtil.outputConversation("send", allMessages);
        ChatCompletionRequest request = requestBuilder.build();
        return (ChatCompletionResponse)this.deepSeekClient.chatCompletion(request).execute();
    }

    @Override
    public ChatCompletionResponse createChat(List<Message> messages, Message schemaMessage, Class<?> topic, Modes mode, DeepSeekOptions options) {
        ChatCompletionRequest.Builder requestBuilder = ChatCompletionRequest.builder().model(mode.getName());
        requestBuilder.responseFormat(schemaMessage == null ? ResponseFormatType.TEXT : ResponseFormatType.JSON_OBJECT);
        requestBuilder.messages(messages);
        DebugUtil.outputConversation("send", messages);
        ChatCompletionRequest request = requestBuilder.build();
        return (ChatCompletionResponse)this.deepSeekClient.chatCompletion(request).execute();
    }

    private ResponseFormat dataFormat(Class<?> topic) {
        if (topic == null || topic == String.class) {
            return ResponseFormat.builder().type(ResponseFormatType.TEXT).build();
        }
        Field[] fields = topic.getFields();
        JsonSchema.Builder schemaBuilder = JsonSchema.builder();
        JsonObjectSchema.Builder objectSchemaBuilder = JsonObjectSchema.builder();
        HashMap<String, JsonSchemaElement> elements = new HashMap<String, JsonSchemaElement>();
        for (Field field : fields) {
            Schema schema = this.schemaGenerator.schemaAnnotation(field);
            JsonSchemaElement schemaEle = this.propertyFormat(field, schema);
            elements.put(field.getName(), schemaEle);
        }
        objectSchemaBuilder.properties(elements);
        schemaBuilder.schema(objectSchemaBuilder.build());
        return ResponseFormat.builder().type(ResponseFormatType.JSON_OBJECT).jsonSchema(schemaBuilder.build()).build();
    }

    private JsonSchemaElement propertyFormat(Field field, Schema schema) {
        boolean isByte;
        Class<Object> type = field.getType();
        if (type == String.class) {
            return JsonStringSchema.builder().description(schema.description()).build();
        }
        boolean isInt = type == Integer.class || type == Integer.TYPE;
        boolean isLong = type == Long.class || type == Long.TYPE;
        boolean isShort = type == Short.class || type == Short.TYPE;
        boolean bl = isByte = type == Byte.class || type == Byte.TYPE;
        if (isInt || isLong || isShort || isByte) {
            return JsonIntegerSchema.builder().description(schema.description()).build();
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return JsonBooleanSchema.builder().description(schema.description()).build();
        }
        if (type.isAssignableFrom(List.class)) {
            return JsonArraySchema.builder().description(schema.description()).build();
        }
        if (type.isAssignableFrom(Number.class)) {
            return JsonNumberSchema.builder().description(schema.description()).build();
        }
        if (type.isEnum()) {
            return JsonEnumSchema.builder().description(schema.description()).enumValues(type).build();
        }
        return null;
    }
}

