/*
 * Decompiled with CFR 0.152.
 */
package ltd.dudu.dsrc;

import com.alibaba.fastjson2.JSON;
import io.github.pigmesh.ai.deepseek.core.chat.AssistantMessage;
import io.github.pigmesh.ai.deepseek.core.chat.ChatCompletionChoice;
import io.github.pigmesh.ai.deepseek.core.chat.ChatCompletionResponse;
import io.github.pigmesh.ai.deepseek.core.chat.Message;
import io.github.pigmesh.ai.deepseek.core.chat.UserMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import ltd.dudu.dsrc.Modes;
import ltd.dudu.dsrc.SchemaGenerator;
import ltd.dudu.dsrc.pojo.DeepSeekOptions;

public interface DeepSeekReverseCall {
    default public <T> T api(List<Message> messages, Class<T> returnType) throws IOException {
        return this.api(messages, returnType, Modes.chat);
    }

    default public <T> T api(List<Message> messages, Class<T> returnType, Modes mode) throws IOException {
        return this.api(messages, returnType, null, mode);
    }

    default public <T> T api(List<Message> messages, Class<T> returnType, DeepSeekOptions options) throws IOException {
        return this.api(messages, returnType, options, Modes.chat);
    }

    public <T> T api(List<Message> var1, Class<T> var2, DeepSeekOptions var3, Modes var4) throws IOException;

    default public String api(List<Message> messages) throws IOException {
        return this.api(messages, (String)null);
    }

    default public String api(List<Message> messages, String prompt) throws IOException {
        return this.api(messages, prompt, Modes.chat);
    }

    default public String api(List<Message> messages, String prompt, Modes mode) throws IOException {
        return this.api(messages, prompt, null, mode);
    }

    default public String api(List<Message> messages, String prompt, DeepSeekOptions options) throws IOException {
        return this.api(messages, prompt, options, Modes.chat);
    }

    public String api(List<Message> var1, String var2, DeepSeekOptions var3, Modes var4) throws IOException;

    default public String api(String message) throws IOException {
        return this.api(message, (String)null);
    }

    default public String api(String message, String prompt) throws IOException {
        return this.api(this.toUserMessage(message), prompt, null, Modes.chat);
    }

    default public String api(String message, String prompt, Modes mode) throws IOException {
        return this.api(this.toUserMessage(message), prompt, mode);
    }

    default public String api(String message, String prompt, DeepSeekOptions options) throws IOException {
        return this.api(this.toUserMessage(message), prompt, options, Modes.chat);
    }

    default public String api(String message, String prompt, DeepSeekOptions options, Modes mode) throws IOException {
        return this.api(this.toUserMessage(message), prompt, options, mode);
    }

    default public <T> T api(String message, Class<T> returnType) throws IOException {
        return this.api(this.toUserMessage(message), returnType, null, Modes.chat);
    }

    default public <T> T api(String message, Class<T> returnType, Modes mode) throws IOException {
        return this.api(this.toUserMessage(message), returnType, null, mode);
    }

    default public <T> T api(String message, Class<T> returnType, DeepSeekOptions options) throws IOException {
        return this.api(this.toUserMessage(message), returnType, options, Modes.chat);
    }

    default public <T> T api(String message, Class<T> returnType, DeepSeekOptions options, Modes mode) throws IOException {
        return this.api(this.toUserMessage(message), returnType, options, mode);
    }

    default public List<Message> toUserMessage(String message) {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add((Message)UserMessage.from((String)message));
        return messages;
    }

    default public List<Message> reverseRole(List<Message> messages) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        for (Message message : messages) {
            msgs.add(this.reverseRole(message));
        }
        return msgs;
    }

    default public Message reverseRole(Message message) {
        if (message instanceof UserMessage) {
            return AssistantMessage.from((String)this.content(message));
        }
        if (message instanceof AssistantMessage) {
            return UserMessage.from((String)this.content(message));
        }
        return message;
    }

    default public List<Message> allMessage(ChatCompletionResponse response) {
        List choices = response.choices();
        return choices.stream().map(ChatCompletionChoice::message).collect(Collectors.toList());
    }

    default public Message oneMessage(ChatCompletionResponse response) {
        return this.allMessage(response).get(0);
    }

    default public String content(Message message) {
        if (message instanceof UserMessage) {
            Object content = ((UserMessage)message).content();
            return content instanceof String ? (String)content : JSON.toJSONString((Object)content);
        }
        if (message instanceof AssistantMessage) {
            return ((AssistantMessage)message).content();
        }
        return message.toString();
    }

    default public String content(ChatCompletionResponse response) {
        return this.content(this.allMessage(response).get(0));
    }

    public List<Message> subTopic(Class<?> var1, Object var2, Message var3, List<Message> var4, ChatCompletionResponse var5, DeepSeekOptions var6, Modes var7);

    public List<Message> subTopic(String var1, Object var2, Message var3, List<Message> var4, ChatCompletionResponse var5, DeepSeekOptions var6, Modes var7);

    public SchemaGenerator getSchemaGenerator();
}

