/*
 * Decompiled with CFR 0.152.
 */
package ltd.dudu.dsrc;

import com.alibaba.fastjson2.JSON;
import io.github.pigmesh.ai.deepseek.core.chat.ChatCompletionResponse;
import io.github.pigmesh.ai.deepseek.core.chat.Message;
import io.github.pigmesh.ai.deepseek.core.chat.SystemMessage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.util.Pair;
import lombok.Generated;
import ltd.dudu.dsrc.DeepSeek;
import ltd.dudu.dsrc.DeepSeekReverseCall;
import ltd.dudu.dsrc.DsrcAnswer;
import ltd.dudu.dsrc.DsrcApi;
import ltd.dudu.dsrc.DsrcInterceptor;
import ltd.dudu.dsrc.Modes;
import ltd.dudu.dsrc.SchemaGenerator;
import ltd.dudu.dsrc.TalkingConvertor;
import ltd.dudu.dsrc.internal.JsonSchemaGenerator;
import ltd.dudu.dsrc.internal.TalkingConvertorReflectImpl;
import ltd.dudu.dsrc.pojo.DeepSeekOptions;
import ltd.dudu.dsrc.utils.DebugUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepSeekReverseCallImpl
implements DeepSeekReverseCall {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeepSeekReverseCallImpl.class);
    private final DeepSeek deepSeek;
    private final Collection<DsrcAnswer> answers;
    private final boolean allowAnswer;
    private final Collection<DsrcInterceptor> interceptors;
    private final SchemaGenerator schemaGenerator;
    private final TalkingConvertor talkingConverter = new TalkingConvertorReflectImpl();
    private final Map<String, Pair<Method, DsrcAnswer>> answerMap = new HashMap<String, Pair<Method, DsrcAnswer>>();
    private final Map<String, Map<String, String>> apiRouters = new HashMap<String, Map<String, String>>();
    private final Map<String, Message> schemaFormatEntity = new HashMap<String, Message>();
    private final Map<String, Message> schemaFormatReverse = new HashMap<String, Message>();

    public DeepSeekReverseCallImpl(DeepSeek deepSeek) {
        this.schemaGenerator = new JsonSchemaGenerator();
        this.deepSeek = deepSeek;
        this.answers = null;
        this.allowAnswer = false;
        this.interceptors = null;
    }

    public DeepSeekReverseCallImpl(DeepSeek deepSeek, Collection<DsrcAnswer> answers) {
        this.schemaGenerator = new JsonSchemaGenerator();
        this.deepSeek = deepSeek;
        this.answers = answers;
        this.allowAnswer = answers != null && answers.iterator().hasNext();
        this.interceptors = null;
        this.registerAnswers();
    }

    public DeepSeekReverseCallImpl(DeepSeek deepSeek, Collection<DsrcAnswer> answers, Collection<DsrcInterceptor> interceptors) {
        this.schemaGenerator = new JsonSchemaGenerator();
        this.deepSeek = deepSeek;
        this.answers = answers;
        this.interceptors = interceptors;
        this.allowAnswer = answers != null && answers.iterator().hasNext();
        this.registerAnswers();
    }

    public DeepSeekReverseCallImpl(DeepSeek deepSeek, Collection<DsrcAnswer> answers, Collection<DsrcInterceptor> interceptors, SchemaGenerator schemaGenerator) {
        this.schemaGenerator = schemaGenerator;
        this.deepSeek = deepSeek;
        this.answers = answers;
        this.interceptors = interceptors;
        this.allowAnswer = answers != null && answers.iterator().hasNext();
        this.registerAnswers();
    }

    @Override
    public <T> T api(List<Message> messages, Class<T> topic, DeepSeekOptions options, Modes mode) throws IOException {
        return this.api(messages, topic, options, mode, false);
    }

    public <T> T api(List<Message> messages, Class<T> topic, DeepSeekOptions options, Modes mode, boolean bySubTopic) throws IOException {
        List<Message> systemMessage = this.schemaGenerator.topicMessage(topic, this);
        Message schemaMessage = this.getSchemaMessage(topic, bySubTopic);
        ArrayList<Message> allMessages = new ArrayList<Message>(systemMessage);
        if (schemaMessage != null) {
            allMessages.add(schemaMessage);
        }
        allMessages.addAll(messages);
        ChatCompletionResponse result = this.deepSeek.createChat(allMessages, schemaMessage, topic, mode, options);
        DebugUtil.outputConversation("receive", this.allMessage(result));
        Message message = this.oneMessage(result);
        this.doIntercepts(result);
        T resultObj = this.resultToReturn(result, topic);
        if (this.schemaGenerator.subTopics(topic).isEmpty()) {
            return resultObj;
        }
        List<Message> nextStep = this.subTopic(topic, resultObj, message, messages, result, options, mode);
        if (nextStep != null && !nextStep.isEmpty()) {
            messages.addAll(nextStep);
            return this.api(messages, topic, options, mode, true);
        }
        return resultObj;
    }

    private <T> Message getSchemaMessage(Class<T> topic, boolean bySubTopic) {
        String topicName = this.schemaGenerator.topicName(topic);
        if (bySubTopic) {
            String schemaMessage = this.schemaGenerator.schemaMessage(topic);
            Message message = this.schemaFormatReverse.get(topicName);
            if (message != null) {
                return message;
            }
            SystemMessage formatMessage = SystemMessage.from((String)("output json: " + schemaMessage));
            this.schemaFormatReverse.put(topicName, (Message)formatMessage);
            return formatMessage;
        }
        return this.schemaFormatEntity.get(topicName);
    }

    @Override
    public String api(List<Message> messages, String prompt, DeepSeekOptions options, Modes mode) throws IOException {
        List<Message> newMessage;
        if (prompt != null && !prompt.isEmpty()) {
            SystemMessage promptMessage = SystemMessage.from((String)prompt);
            newMessage = new ArrayList<Message>();
            newMessage.add((Message)promptMessage);
            newMessage.addAll(messages);
        } else {
            newMessage = messages;
        }
        ChatCompletionResponse result = this.deepSeek.createChat(newMessage, mode, options);
        DebugUtil.outputConversation("receive", this.allMessage(result));
        this.doIntercepts(result);
        return this.content(result);
    }

    @Override
    public List<Message> subTopic(Class<?> topic, Object resultObj, Message message, List<Message> messages, ChatCompletionResponse result, DeepSeekOptions options, Modes mode) {
        String topicName = this.schemaGenerator.topicName(topic);
        return this.subTopic(topicName, topic, resultObj, message, messages, result, options, mode);
    }

    @Override
    public List<Message> subTopic(String topicName, Object resultObj, Message message, List<Message> messages, ChatCompletionResponse result, DeepSeekOptions options, Modes mode) {
        Class<?> topic = resultObj == null ? null : resultObj.getClass();
        return this.subTopic(topicName, topic, resultObj, message, messages, result, options, mode);
    }

    private List<Message> subTopic(String topicName, Class<?> topic, Object resultObj, Message message, List<Message> messages, ChatCompletionResponse result, DeepSeekOptions options, Modes mode) {
        try {
            return this.talkingConverter.subTopic(topic, resultObj, message, messages, result, options, mode, this);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T tryParse(String content, Class<T> clazz) {
        if ((content = content.trim()).startsWith("```json") && content.endsWith("```")) {
            content = content.substring(7, content.length() - 3).trim();
        }
        return (T)JSON.parseObject((String)content, clazz);
    }

    private <T> T resultToReturn(ChatCompletionResponse result, Class<T> clazz) {
        if (clazz == String.class) {
            return (T)this.content(result);
        }
        if (clazz == Object.class) {
            return (T)result;
        }
        if (clazz == List.class) {
            return (T)this.allMessage(result);
        }
        return this.tryParse(this.content(result), clazz);
    }

    private boolean doIntercepts(ChatCompletionResponse result) {
        boolean returnDefault = false;
        if (this.interceptors != null) {
            for (DsrcInterceptor interceptor : this.interceptors) {
                boolean hasNext = interceptor.intercept(result);
                if (hasNext) continue;
                returnDefault = true;
            }
        }
        return returnDefault;
    }

    private void registerAnswers() {
        if (!this.allowAnswer) {
            return;
        }
        for (DsrcAnswer answer : this.answers) {
            Method[] methods;
            DsrcApi api = answer.getClass().getAnnotation(DsrcApi.class);
            if (api == null) continue;
            String apiName = api.value();
            for (Method method : methods = answer.getClass().getMethods()) {
                String methodApiName;
                DsrcApi methodApi = method.getAnnotation(DsrcApi.class);
                if (methodApi == null || (methodApiName = methodApi.value()).isEmpty()) continue;
                String topicName = apiName + "." + methodApiName;
                this.answerMap.put(topicName, (Pair<Method, DsrcAnswer>)new Pair((Object)method, (Object)answer));
                this.cacheSchemaFormat(topicName, method);
            }
        }
    }

    private void cacheSchemaFormat(String topicName, Method method) {
        Message message = this.talkingConverter.schemaMessage(method, this);
        if (message != null) {
            this.schemaFormatEntity.put(topicName, message);
        }
    }

    @Generated
    public DeepSeek getDeepSeek() {
        return this.deepSeek;
    }

    @Generated
    public Collection<DsrcAnswer> getAnswers() {
        return this.answers;
    }

    @Generated
    public boolean isAllowAnswer() {
        return this.allowAnswer;
    }

    @Generated
    public Collection<DsrcInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    @Generated
    public SchemaGenerator getSchemaGenerator() {
        return this.schemaGenerator;
    }

    @Generated
    public TalkingConvertor getTalkingConverter() {
        return this.talkingConverter;
    }

    @Generated
    public Map<String, Pair<Method, DsrcAnswer>> getAnswerMap() {
        return this.answerMap;
    }

    @Generated
    public Map<String, Map<String, String>> getApiRouters() {
        return this.apiRouters;
    }

    @Generated
    public Map<String, Message> getSchemaFormatEntity() {
        return this.schemaFormatEntity;
    }

    @Generated
    public Map<String, Message> getSchemaFormatReverse() {
        return this.schemaFormatReverse;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeepSeekReverseCallImpl)) {
            return false;
        }
        DeepSeekReverseCallImpl other = (DeepSeekReverseCallImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAllowAnswer() != other.isAllowAnswer()) {
            return false;
        }
        DeepSeek this$deepSeek = this.getDeepSeek();
        DeepSeek other$deepSeek = other.getDeepSeek();
        if (this$deepSeek == null ? other$deepSeek != null : !this$deepSeek.equals(other$deepSeek)) {
            return false;
        }
        Collection<DsrcAnswer> this$answers = this.getAnswers();
        Collection<DsrcAnswer> other$answers = other.getAnswers();
        if (this$answers == null ? other$answers != null : !((Object)this$answers).equals(other$answers)) {
            return false;
        }
        Collection<DsrcInterceptor> this$interceptors = this.getInterceptors();
        Collection<DsrcInterceptor> other$interceptors = other.getInterceptors();
        if (this$interceptors == null ? other$interceptors != null : !((Object)this$interceptors).equals(other$interceptors)) {
            return false;
        }
        SchemaGenerator this$schemaGenerator = this.getSchemaGenerator();
        SchemaGenerator other$schemaGenerator = other.getSchemaGenerator();
        if (this$schemaGenerator == null ? other$schemaGenerator != null : !this$schemaGenerator.equals(other$schemaGenerator)) {
            return false;
        }
        TalkingConvertor this$talkingConverter = this.getTalkingConverter();
        TalkingConvertor other$talkingConverter = other.getTalkingConverter();
        if (this$talkingConverter == null ? other$talkingConverter != null : !this$talkingConverter.equals(other$talkingConverter)) {
            return false;
        }
        Map<String, Pair<Method, DsrcAnswer>> this$answerMap = this.getAnswerMap();
        Map<String, Pair<Method, DsrcAnswer>> other$answerMap = other.getAnswerMap();
        if (this$answerMap == null ? other$answerMap != null : !((Object)this$answerMap).equals(other$answerMap)) {
            return false;
        }
        Map<String, Map<String, String>> this$apiRouters = this.getApiRouters();
        Map<String, Map<String, String>> other$apiRouters = other.getApiRouters();
        if (this$apiRouters == null ? other$apiRouters != null : !((Object)this$apiRouters).equals(other$apiRouters)) {
            return false;
        }
        Map<String, Message> this$schemaFormatEntity = this.getSchemaFormatEntity();
        Map<String, Message> other$schemaFormatEntity = other.getSchemaFormatEntity();
        if (this$schemaFormatEntity == null ? other$schemaFormatEntity != null : !((Object)this$schemaFormatEntity).equals(other$schemaFormatEntity)) {
            return false;
        }
        Map<String, Message> this$schemaFormatReverse = this.getSchemaFormatReverse();
        Map<String, Message> other$schemaFormatReverse = other.getSchemaFormatReverse();
        return !(this$schemaFormatReverse == null ? other$schemaFormatReverse != null : !((Object)this$schemaFormatReverse).equals(other$schemaFormatReverse));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeepSeekReverseCallImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowAnswer() ? 79 : 97);
        DeepSeek $deepSeek = this.getDeepSeek();
        result = result * 59 + ($deepSeek == null ? 43 : $deepSeek.hashCode());
        Collection<DsrcAnswer> $answers = this.getAnswers();
        result = result * 59 + ($answers == null ? 43 : ((Object)$answers).hashCode());
        Collection<DsrcInterceptor> $interceptors = this.getInterceptors();
        result = result * 59 + ($interceptors == null ? 43 : ((Object)$interceptors).hashCode());
        SchemaGenerator $schemaGenerator = this.getSchemaGenerator();
        result = result * 59 + ($schemaGenerator == null ? 43 : $schemaGenerator.hashCode());
        TalkingConvertor $talkingConverter = this.getTalkingConverter();
        result = result * 59 + ($talkingConverter == null ? 43 : $talkingConverter.hashCode());
        Map<String, Pair<Method, DsrcAnswer>> $answerMap = this.getAnswerMap();
        result = result * 59 + ($answerMap == null ? 43 : ((Object)$answerMap).hashCode());
        Map<String, Map<String, String>> $apiRouters = this.getApiRouters();
        result = result * 59 + ($apiRouters == null ? 43 : ((Object)$apiRouters).hashCode());
        Map<String, Message> $schemaFormatEntity = this.getSchemaFormatEntity();
        result = result * 59 + ($schemaFormatEntity == null ? 43 : ((Object)$schemaFormatEntity).hashCode());
        Map<String, Message> $schemaFormatReverse = this.getSchemaFormatReverse();
        result = result * 59 + ($schemaFormatReverse == null ? 43 : ((Object)$schemaFormatReverse).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeepSeekReverseCallImpl(deepSeek=" + this.getDeepSeek() + ", answers=" + this.getAnswers() + ", allowAnswer=" + this.isAllowAnswer() + ", interceptors=" + this.getInterceptors() + ", schemaGenerator=" + this.getSchemaGenerator() + ", talkingConverter=" + this.getTalkingConverter() + ", answerMap=" + this.getAnswerMap() + ", apiRouters=" + this.getApiRouters() + ", schemaFormatEntity=" + this.getSchemaFormatEntity() + ", schemaFormatReverse=" + this.getSchemaFormatReverse() + ")";
    }
}

