/*
 * Decompiled with CFR 0.152.
 */
package ltd.dudu.dsrc.internal;

import io.github.pigmesh.ai.deepseek.core.chat.Message;
import io.github.pigmesh.ai.deepseek.core.chat.SystemMessage;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ltd.dudu.dsrc.DeepSeekReverseCallImpl;
import ltd.dudu.dsrc.DsrcApi;
import ltd.dudu.dsrc.SchemaGenerator;
import org.stringtemplate.v4.ST;

public class JsonSchemaGenerator
implements SchemaGenerator {
    @Override
    public String topicName(Class<?> topic) {
        if (topic == null) {
            return null;
        }
        DsrcApi dsrcApi = topic.getAnnotation(DsrcApi.class);
        return dsrcApi.value();
    }

    @Override
    public Class<?> findSubTopic(Class<?> topic, String topicName) {
        DsrcApi dsrcApi = topic.getAnnotation(DsrcApi.class);
        Class[] classes = dsrcApi.subTopics();
        return Arrays.stream(classes).filter(c -> this.topicName((Class<?>)c).equals(topicName)).findFirst().orElse(null);
    }

    @Override
    public String fieldMessage(Class<?> topic, Field field) {
        Schema schema = this.schemaAnnotation(field);
        String schemaStr = schema.description();
        if (topic.isAnnotationPresent(DsrcApi.class)) {
            Map<String, String> subTopicSchema;
            DsrcApi annotation = topic.getAnnotation(DsrcApi.class);
            Class[] classes = annotation.subTopics();
            String[] plainTopics = annotation.plainTopics();
            if (classes.length > 0 && !(subTopicSchema = Arrays.stream(classes).collect(Collectors.toMap(this::topicName, this::schemaMessage))).isEmpty()) {
                ST st = new ST(schemaStr);
                st.add("topicKeys", (Object)String.join((CharSequence)"|", subTopicSchema.keySet()));
                st.add("topicValues", (Object)String.join((CharSequence)"|", subTopicSchema.values()));
                schemaStr = st.render();
            }
        } else {
            schemaStr = field.getName();
        }
        return String.format("\"%s\": <%s>", field.getName(), schemaStr);
    }

    @Override
    public Schema schemaAnnotation(Field field) {
        return field.getAnnotation(Schema.class);
    }

    @Override
    public String schemaMessage(Class<?> topic) {
        String fields = Arrays.stream(topic.getDeclaredFields()).map(field -> this.fieldMessage(topic, (Field)field)).collect(Collectors.joining(","));
        return String.format("{ %s }", fields);
    }

    @Override
    public List<Message> topicMessage(Class<?> topic, DeepSeekReverseCallImpl dsrc) {
        ArrayList<Message> systemMessages = new ArrayList<Message>();
        if (topic.getAnnotation(DsrcApi.class) != null) {
            DsrcApi dsrcApi = topic.getAnnotation(DsrcApi.class);
            Arrays.stream(dsrcApi.prompt()).map(SystemMessage::from).forEach(systemMessages::add);
        }
        return systemMessages;
    }

    @Override
    public List<Class> subTopics(Class<?> topic) {
        DsrcApi dsrcApi = topic.getAnnotation(DsrcApi.class);
        if (dsrcApi == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(dsrcApi.subTopics());
    }
}

