/*
 * Decompiled with CFR 0.152.
 */
package ltd.icecold.orange.bilibili;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ltd.icecold.orange.bilibili.bean.BilibiliVideoUrl;
import ltd.icecold.orange.network.Request;
import ltd.icecold.orange.network.UserAgent;
import ltd.icecold.orange.utils.BilibiliDownloaderThread;
import org.apache.commons.codec.digest.DigestUtils;
import org.jsoup.Connection;

public class BilibiliVideoAPI {
    private BilibiliVideoUrl bilibiliVideoUrl;

    public static String bv2Av(String bid) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", UserAgent.WINDOWS10_CHROME.getUserAgent());
        Connection.Response response = Request.sendGet("http://api.bilibili.com/x/web-interface/archive/stat?bvid=" + bid, headers, new HashMap<String, String>());
        String body = response.body();
        if (new JsonParser().parse(body).getAsJsonObject().get("code").getAsInt() != 0) {
            return null;
        }
        return new JsonParser().parse(body).getAsJsonObject().get("data").getAsJsonObject().get("aid").getAsString();
    }

    public static String getCid(String aid) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", UserAgent.WINDOWS10_CHROME.getUserAgent());
        Connection.Response response = Request.sendGet("https://api.bilibili.com/x/web-interface/view?aid=" + aid, headers, new HashMap<String, String>());
        String body = response.body();
        if (new JsonParser().parse(body).getAsJsonObject().get("code").getAsInt() != 0) {
            return null;
        }
        return new JsonParser().parse(body).getAsJsonObject().get("data").getAsJsonObject().get("cid").getAsString();
    }

    public BilibiliVideoAPI getVideoUrlV1(String bid) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", UserAgent.WINDOWS10_CHROME.getUserAgent());
        String aid = BilibiliVideoAPI.bv2Av(bid);
        String cid = BilibiliVideoAPI.getCid(aid);
        System.out.println();
        String params = "appkey=iVGUTjsxvpLeuDCf&cid=" + cid + "&otype=json&qn=112&quality=112&type=";
        String sign = DigestUtils.md5Hex(params + "aHRmhWMLkdeMuILqORnYZocwMBpMEOdt");
        String apiUrl = "https://interface.bilibili.com/v2/playurl?" + params + "&sign=" + sign;
        headers.put("Referer", apiUrl);
        Connection.Response response = Request.sendGet(apiUrl, headers, new HashMap<String, String>());
        String body = response.body();
        JsonArray durl = new JsonParser().parse(body).getAsJsonObject().get("durl").getAsJsonArray();
        ArrayList<String> videoUrlList = new ArrayList<String>();
        for (JsonElement videoUrl : durl) {
            videoUrlList.add(videoUrl.getAsJsonObject().get("url").getAsString());
        }
        this.bilibiliVideoUrl = new BilibiliVideoUrl(apiUrl, videoUrlList);
        return this;
    }

    public BilibiliVideoUrl getVideoUrlList() {
        return this.bilibiliVideoUrl;
    }

    public List<BilibiliDownloaderThread> download(File targetFile, int threadNum) throws Exception {
        if (this.bilibiliVideoUrl.getVideoUrlList().size() == 0) {
            throw new NullPointerException("Null Video Info");
        }
        ArrayList<BilibiliDownloaderThread> download = new ArrayList<BilibiliDownloaderThread>();
        for (String url : this.bilibiliVideoUrl.getVideoUrlList()) {
            BilibiliDownloaderThread bilibiliDownloaderThread = new BilibiliDownloaderThread(url, targetFile, threadNum, this.bilibiliVideoUrl.getRefererUrl());
            bilibiliDownloaderThread.start();
            download.add(bilibiliDownloaderThread);
        }
        return download;
    }
}

