/*
 * Decompiled with CFR 0.152.
 */
package ltd.icecold.orange.utils;

import java.text.DecimalFormat;

public class ConsoleProgressBar {
    private final int barLen;
    private char showChar;
    private DecimalFormat formater = new DecimalFormat("#.##%");

    public ConsoleProgressBar(int barLen, char showChar) {
        this.barLen = barLen;
        this.showChar = showChar;
    }

    public void show(int value) {
        if (value < 0 || value > 100) {
            return;
        }
        this.reset();
        float rate = (float)((double)value * 1.0 / 100.0);
        this.draw(this.barLen, rate);
        if ((long)value == 100L) {
            this.afterComplete();
        }
    }

    private void draw(int barLen, float rate) {
        int i;
        int len = (int)(rate * (float)barLen);
        System.out.print("Downloading: ");
        for (i = 0; i < len; ++i) {
            System.out.print(this.showChar);
        }
        for (i = 0; i < barLen - len; ++i) {
            System.out.print(" ");
        }
        System.out.print(" |" + this.format(rate));
    }

    private void reset() {
        System.out.print('\r');
    }

    private void afterComplete() {
        System.out.print('\n');
    }

    private String format(float num) {
        return this.formater.format(num);
    }
}

