/*
 * Decompiled with CFR 0.152.
 */
package ltd.icecold.orange.netease.api;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ltd.icecold.orange.netease.NeteaseCrypto;
import ltd.icecold.orange.netease.NeteaseRequest;
import ltd.icecold.orange.netease.bean.NeteaseRequestOptions;
import ltd.icecold.orange.netease.bean.NeteaseResponseBody;
import ltd.icecold.orange.network.Request;
import ltd.icecold.orange.network.UserAgent;
import ltd.icecold.orange.utils.Utils;
import org.apache.commons.codec.digest.DigestUtils;
import org.jsoup.Connection;

public class NeteaseSongAPI {
    public static NeteaseResponseBody musicUrl(String id, String br, Map<String, String> cookie) {
        if (!cookie.containsKey("MUSIC_U")) {
            cookie.put("_ntes_nuid", DigestUtils.md5Hex((String)Utils.getRandomString(16)));
        }
        cookie.put("os", "pc");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("ids", "[" + id + "]");
        data.put("br", br);
        NeteaseRequestOptions requestOptions = new NeteaseRequestOptions("https://music.163.com/api/song/enhance/player/url", NeteaseCrypto.CryptoType.LINUXAPI, cookie, Request.UserAgentType.PC);
        return NeteaseRequest.postRequest(requestOptions, data);
    }

    public static NeteaseResponseBody lyric(String id) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Referer", "https://music.163.com");
        headers.put("User-Agent", UserAgent.WINDOWS10_FIREFOX.getUserAgent());
        headers.put("X-Real-IP", Request.getRandomChinaIp());
        try {
            Connection.Response response = Request.sendGet("https://music.163.com/api/song/lyric?id=" + id + "&lv=-1&kv=-1&tv=-1", headers, new HashMap<String, String>());
            return new NeteaseResponseBody(response.cookies(), response.body(), response.statusCode());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean checkMusic(String id, Map<String, String> cookie) {
        return NeteaseSongAPI.checkMusic(id, "999000", cookie);
    }

    public static boolean checkMusic(String id, String br, Map<String, String> cookie) {
        NeteaseRequestOptions requestOptions = new NeteaseRequestOptions("https://music.163.com/weapi/song/enhance/player/url", NeteaseCrypto.CryptoType.WEAPI, cookie, Request.UserAgentType.PC);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("ids", "[" + id + "]");
        data.put("br", br);
        JsonObject asJsonObject = new JsonParser().parse(NeteaseRequest.postRequest(requestOptions, data).getBody()).getAsJsonObject();
        if (asJsonObject.get("code").getAsInt() == 200) {
            return asJsonObject.get("data").getAsJsonArray().get(0).getAsJsonObject().get("code").getAsInt() == 200;
        }
        return false;
    }
}

