/*
 * Decompiled with CFR 0.152.
 */
package ltd.icecold.orange.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Random;

public class Utils {
    public static String toPrettyFormat(String json) {
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = jsonParser.parse(json).getAsJsonObject();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(jsonObject);
    }

    public static String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(62);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            String sTmp = Integer.toHexString(0xFF & bytes[i]);
            if (sTmp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTmp);
        }
        return sb.toString();
    }

    public static String padStart(int length, int number) {
        String f = "%0" + length + "d";
        return String.format(f, number);
    }

    public static String encodeURIComponent(String data) {
        String result = null;
        try {
            result = URLEncoder.encode(data, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            result = data;
        }
        return result;
    }

    public static String cookieMap2String(Map<String, String> cookie) {
        StringBuilder stringBuilder = new StringBuilder();
        cookie.forEach((key, value) -> stringBuilder.append((String)key).append("=").append((String)value).append(";"));
        return stringBuilder.toString();
    }
}

