/*
 * Decompiled with CFR 0.152.
 */
package ltd.icecold.orange.netease.api;

import java.util.HashMap;
import java.util.Map;
import ltd.icecold.orange.netease.NeteaseCrypto;
import ltd.icecold.orange.netease.NeteaseRequest;
import ltd.icecold.orange.netease.bean.NeteaseRequestOptions;
import ltd.icecold.orange.netease.bean.NeteaseResponseBody;
import ltd.icecold.orange.network.Request;

public class NeteaseUserAPI {
    private Map<String, String> cookie = new HashMap<String, String>();
    public String userDetail;

    public Map<String, String> getCookie() {
        return this.cookie;
    }

    public NeteaseResponseBody login(String userName, String password) {
        this.cookie.put("os", "pc");
        NeteaseRequestOptions requestOptions = new NeteaseRequestOptions("https://music.163.com/weapi/login", NeteaseCrypto.CryptoType.WEAPI, this.cookie, Request.UserAgentType.PC);
        System.out.println(requestOptions.getUserAgent());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("username", userName);
        data.put("password", password);
        data.put("rememberLogin", "true");
        NeteaseResponseBody responseBody = NeteaseRequest.postRequest(requestOptions, data);
        this.cookie = responseBody.getCookie();
        this.userDetail = responseBody.getBody();
        return responseBody;
    }

    public NeteaseResponseBody loginPhone(String phone, String password) {
        this.cookie.put("os", "pc");
        NeteaseRequestOptions requestOptions = new NeteaseRequestOptions("https://music.163.com/weapi/login/cellphone", NeteaseCrypto.CryptoType.WEAPI, this.cookie, Request.UserAgentType.PC);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("phone", phone);
        data.put("password", password);
        data.put("rememberLogin", "true");
        NeteaseResponseBody responseBody = NeteaseRequest.postRequest(requestOptions, data);
        this.cookie = responseBody.getCookie();
        this.userDetail = responseBody.getBody();
        return responseBody;
    }

    public NeteaseResponseBody loginRefresh() {
        if (this.cookie.isEmpty()) {
            throw new NullPointerException("Not logged in yet");
        }
        NeteaseRequestOptions requestOptions = new NeteaseRequestOptions("https://music.163.com/weapi/login/token/refresh", NeteaseCrypto.CryptoType.WEAPI, this.cookie, Request.UserAgentType.PC);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("csrf_token", this.cookie.get("__csrf"));
        NeteaseResponseBody responseBody = NeteaseRequest.postRequest(requestOptions, data);
        this.cookie = responseBody.getCookie();
        this.userDetail = responseBody.getBody();
        return responseBody;
    }
}

