/*
 * Decompiled with CFR 0.152.
 */
package ltd.icecold.orange.bilibili.user;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import ltd.icecold.orange.bilibili.bean.LoginChallenge;
import ltd.icecold.orange.bilibili.user.CaptchaCallback;

public class BilibiliLoginChallenge {
    private LoginChallenge loginChallenge;
    private CaptchaCallback callback;

    public BilibiliLoginChallenge(LoginChallenge loginChallenge, CaptchaCallback callback) {
        this.loginChallenge = loginChallenge;
        this.callback = callback;
    }

    public String challengeView(Integer port) throws IOException {
        HttpServer viewServer = HttpServer.create(new InetSocketAddress(port), 0);
        int resultServerPort = this.getResult();
        System.out.println("http://127.0.0.1:" + port + "/challenge");
        viewServer.createContext("/challenge", httpExchange -> {
            String html = "<!DOCTYPE html>\n<html lang=\"en\">\n\n<head>\n    <meta charset=\"UTF-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <title>Bilibili Login Challenge</title>\n    <link href=\"https://cdn.jsdelivr.net/gh/GceCold/orange@master/html/css/style.css\" rel=\"stylesheet\" type=\"text/css\">\n</head>\n\n<body>\n<div>\n    <label>\u9a8c\u8bc1\uff1a</label>\n    <div id=\"captcha\">\n        <div id=\"wait\" class=\"show\">\n            <div class=\"loading\">\n                <div class=\"loading-dot\"></div>\n                <div class=\"loading-dot\"></div>\n                <div class=\"loading-dot\"></div>\n                <div class=\"loading-dot\"></div>\n            </div>\n        </div>\n    </div>\n</div>\n<br>\n\n<div id=\"btn-result\" class=\"btn\">\u5b8c\u6210</div>\n<br><br>\n\n<div>\n    <label for=\"validate\">validate: </label>\n    <input class=\"inp\" id=\"validate\" type=\"text\" readonly=\"readonly\">\n</div>\n<br>\n\n<div>\n    <label for=\"seccode\">seccode: </label>\n    <input class=\"inp\" id=\"seccode\" type=\"text\" readonly=\"readonly\">\n</div>\n<br>\n\n\n<script src=\"https://cdn.jsdelivr.net/gh/GceCold/orange@master/html/js/jquery.js\"></script>\n<script src=\"https://cdn.jsdelivr.net/gh/GceCold/orange@master/html/js/gt.js\"></script>\n\n<script>\n        var handler = function (captchaObj) {\n            captchaObj.appendTo('#captcha');\n            captchaObj.onReady(function () {\n                $(\"#wait\").hide();\n            });\n            $('#btn-result').click(function () {\n                var result = captchaObj.getValidate();\n                if (!result) {\n                    return alert('\u8bf7\u5b8c\u6210\u9a8c\u8bc1');\n                }\n                var validate = $('#validate')[0];\n                var seccode = $('#seccode')[0];\n                validate.value = result.geetest_validate;\n                seccode.value = result.geetest_seccode;\n\n                $.ajax({\n                    type:\"GET\",\n                    url:\"http://127.0.0.1:${PORT}/result?validate=\"+result.geetest_validate+\"&seccode=\"+result.geetest_seccode.replace(\"|jordan\",\"\"),\n                    dataType:\"text\"\n                });\n\n                document.getElementById('btn-result').innerHTML = \"\u9a8c\u8bc1\u6210\u529f\";\n\n                setInterval(function(){\n                    if (window.parent != null) {\n                        window.parent.close();\n                    }else {\n                        window.close();\n                    }\n                },1000)\n\n            });\n            // \u66f4\u591a\u524d\u7aef\u63a5\u53e3\u8bf4\u660e\u8bf7\u53c2\u89c1\uff1ahttp://docs.geetest.com/install/client/web-front/\n        };\n\n        $(document).ready(function () {\n            $('#text').hide();\n            $('#wait').show();\n            var gt = \"${gt}\";\n            var challenge = \"${challenge}\";\n            // \u8c03\u7528 initGeetest \u8fdb\u884c\u521d\u59cb\u5316\n            // \u53c2\u65701\uff1a\u914d\u7f6e\u53c2\u6570\n            // \u53c2\u65702\uff1a\u56de\u8c03\uff0c\u56de\u8c03\u7684\u7b2c\u4e00\u4e2a\u53c2\u6570\u9a8c\u8bc1\u7801\u5bf9\u8c61\uff0c\u4e4b\u540e\u53ef\u4ee5\u4f7f\u7528\u5b83\u8c03\u7528\u76f8\u5e94\u7684\u63a5\u53e3\n            initGeetest({\n                // \u4ee5\u4e0b 4 \u4e2a\u914d\u7f6e\u53c2\u6570\u4e3a\u5fc5\u987b\uff0c\u4e0d\u80fd\u7f3a\u5c11\n                gt: gt,\n                challenge: challenge,\n                offline: false, // \u8868\u793a\u7528\u6237\u540e\u53f0\u68c0\u6d4b\u6781\u9a8c\u670d\u52a1\u5668\u662f\u5426\u5b95\u673a\n                new_captcha: true, // \u7528\u4e8e\u5b95\u673a\u65f6\u8868\u793a\u662f\u65b0\u9a8c\u8bc1\u7801\u7684\u5b95\u673a\n\n                product: \"popup\", // \u4ea7\u54c1\u5f62\u5f0f\uff0c\u5305\u62ec\uff1afloat\uff0cpopup\n                width: \"300px\",\n                https: true\n\n                // \u66f4\u591a\u524d\u7aef\u914d\u7f6e\u53c2\u6570\u8bf4\u660e\u8bf7\u53c2\u89c1\uff1ahttp://docs.geetest.com/install/client/web-front/\n            }, handler);\n        });\n    </script>\n</body>\n\n</html>".replace("${gt}", this.loginChallenge.getGt()).replace("${challenge}", this.loginChallenge.getChallenge()).replace("${PORT}", String.valueOf(resultServerPort));
            httpExchange.getResponseHeaders().add("Content-Type", "text/html; charset=UTF-8");
            httpExchange.sendResponseHeaders(200, html.getBytes(StandardCharsets.UTF_8).length);
            httpExchange.getResponseBody().write(html.getBytes(StandardCharsets.UTF_8));
            httpExchange.close();
        });
        viewServer.start();
        return "";
    }

    public Integer getResult() throws IOException {
        ServerSocket ss = new ServerSocket(0, 1, InetAddress.getByAddress(new byte[]{0, 0, 0, 0}));
        int port = ss.getLocalPort();
        ss.close();
        HttpServer httpServer = HttpServer.create(new InetSocketAddress(port), 0);
        httpServer.createContext("/result", httpExchange -> {
            URI uri = httpExchange.getRequestURI();
            httpExchange.getResponseHeaders().add("Content-Type", "text/html; charset=UTF-8");
            httpExchange.sendResponseHeaders(200, "success".getBytes().length);
            httpExchange.getResponseBody().write("success".getBytes());
            httpExchange.close();
            String getResult = uri.getQuery();
            String[] split = getResult.split("&");
            LoginChallenge.Result result = new LoginChallenge.Result();
            for (int i = 0; i < split.length; ++i) {
                if (split[i].startsWith("validate")) {
                    result.setValidate(split[i]);
                }
                if (!split[i].startsWith("seccode")) continue;
                result.setSeccode(split[i]);
            }
            if (result.getValidate().isEmpty() || result.getSeccode().isEmpty()) {
                throw new NullPointerException("Challenge Result Is Empty");
            }
            this.loginChallenge.setResult(result);
            this.callback.challengeResult(this.loginChallenge);
        });
        httpServer.start();
        return port;
    }

    public LoginChallenge getChallengeResult() {
        return this.loginChallenge;
    }
}

