/*
 * Decompiled with CFR 0.152.
 */
package ltd.icecold.orange.utils.crypto;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import ltd.icecold.orange.utils.Utils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSACrypto {
    public byte[] encryptNoPadding(byte[] originalContent, String encryptKey) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher cipher = Cipher.getInstance("RSA/NONE/NoPadding", "BC");
            PublicKey pubKey = RSACrypto.getPublicKey(encryptKey, 65537);
            cipher.init(1, pubKey);
            return cipher.doFinal(originalContent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static PublicKey getPublicKey(String modulus, int publicExponent) {
        BigInteger bigIntegerModulus = new BigInteger(modulus, 16);
        RSAPublicKeySpec rsaSpec = new RSAPublicKeySpec(bigIntegerModulus, BigInteger.valueOf(publicExponent));
        PublicKey pKey = null;
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            pKey = kf.generatePublic(rsaSpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return pKey;
    }

    public static String rsaEncrypt(String text, String pubKey, String modulus) {
        text = new StringBuffer(text).reverse().toString();
        BigInteger biText = new BigInteger(Utils.bytesToHexString(text.getBytes(StandardCharsets.UTF_8)), 16);
        BigInteger biEx = new BigInteger(pubKey, 16);
        BigInteger biMod = new BigInteger(modulus, 16);
        BigInteger biRet = biText.modPow(biEx, biMod);
        return RSACrypto.zFill(biRet.toString(16), 256);
    }

    private static String zFill(String str, int size) {
        while (str.length() < size) {
            str = "0" + str;
        }
        return str;
    }
}

